/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.compression;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class DataDecompressor<T>
implements IntFunction<T> {
    private Int2ObjectMap<T> int2ObjectMap;
    private IntFunction<T> defaultFun;

    public DataDecompressor(ListNBT list, Function<INBT, T> deserializer, IntFunction<T> defaultFun) {
        this.int2ObjectMap = new Int2ObjectOpenHashMap(list.size());
        this.defaultFun = defaultFun;
        int count = 0;
        for (INBT entry : list) {
            this.int2ObjectMap.put(count++, deserializer.apply(entry));
        }
    }

    @Override
    public T apply(int value) {
        if (!this.int2ObjectMap.containsKey(value)) {
            return this.defaultFun.apply(value);
        }
        return (T)this.int2ObjectMap.get(value);
    }
}

