/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.google.common.base.Preconditions;
import com.mojang.authlib.Agent;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReflectionHelper;

public final class AuthHelper {
    private static final long cacheTime = 300000L;
    private static final Field accessToken;
    private static final Field sessionField;
    private static final Method checkTokenValidity;
    private static final Method logInWithPassword;
    private static final Constructor<YggdrasilUserAuthentication> authConstructor;
    private static final BiFunction<YggdrasilAuthenticationService, String, Object[]> authParameterFactory;
    private SessionStatus status = SessionStatus.UNKNOWN;
    private long lastCheck = 0L;
    private final YggdrasilUserAuthentication checkAuth;
    private final YggdrasilUserAuthentication loginAuth;
    private final Pattern namePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public AuthHelper() {
        Proxy proxy = Minecraft.func_71410_x().func_110437_J();
        String clientId = UUID.randomUUID().toString();
        Object[] checkAuthParams = authParameterFactory.apply(new YggdrasilAuthenticationService(proxy, (String)null), null);
        this.checkAuth = ReflectionHelper.callConstructor(authConstructor, checkAuthParams);
        Object[] loginAuthParams = authParameterFactory.apply(new YggdrasilAuthenticationService(proxy, clientId), clientId);
        this.loginAuth = ReflectionHelper.callConstructor(authConstructor, loginAuthParams);
    }

    public SessionStatus getSessionStatus(boolean force) {
        if (force || this.lastCheck + 300000L < System.currentTimeMillis()) {
            this.status = SessionStatus.UNKNOWN;
        }
        if (this.status == SessionStatus.UNKNOWN) {
            this.status = SessionStatus.REFRESHING;
            this.lastCheck = System.currentTimeMillis();
            Thread t = new Thread(this::updateSessionStatus, "ReAuth Session Validator");
            t.setDaemon(true);
            t.start();
        }
        return this.status;
    }

    private void updateSessionStatus() {
        ReflectionHelper.setField(accessToken, this.checkAuth, this.getSession().func_148254_d());
        boolean valid = (Boolean)ReflectionHelper.callMethod(checkTokenValidity, this.checkAuth, new Object[0]);
        this.status = valid ? SessionStatus.VALID : SessionStatus.INVALID;
        this.lastCheck = System.currentTimeMillis();
    }

    public void login(String user, char[] password, boolean savePassword) throws AuthenticationException {
        this.login(user, new String(password), savePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String user, String password, boolean savePassword) throws AuthenticationException {
        this.loginAuth.setUsername(user);
        this.loginAuth.setPassword(password);
        try {
            try {
                ReflectionHelper.callMethod(logInWithPassword, this.loginAuth, new Object[0]);
            }
            catch (ReflectionHelper.UncheckedInvocationTargetException exception) {
                Throwable parent = exception.getCause();
                if (parent instanceof AuthenticationException) {
                    throw (AuthenticationException)parent;
                }
                ReAuth.log.error("LogInWithPassword has thrown unexpected exception:", parent);
            }
            String username = this.loginAuth.getSelectedProfile().getName();
            String uuid = UUIDTypeAdapter.fromUUID((UUID)this.loginAuth.getSelectedProfile().getId());
            String access = this.loginAuth.getAuthenticatedToken();
            String type = this.loginAuth.getUserType().getName();
            Session session = new Session(username, uuid, access, type);
            session.setProperties(this.loginAuth.getUserProperties());
            this.loginAuth.logOut();
            this.setSession(session);
            ReAuth.config.setCredentials(username, user, savePassword ? password : "");
        }
        finally {
            this.loginAuth.logOut();
        }
    }

    public void offline(String username) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        this.setSession(new Session(username, uuid.toString(), "invalid", "legacy"));
        ReAuth.log.info("Offline Username set!");
        ReAuth.config.setCredentials(username, "", "");
    }

    private Session getSession() {
        return Minecraft.func_71410_x().func_110432_I();
    }

    private void setSession(Session s) {
        ReflectionHelper.setField(sessionField, Minecraft.func_71410_x(), s);
        this.status = SessionStatus.UNKNOWN;
    }

    public boolean isValidName(String username) {
        return this.namePattern.matcher(username).matches();
    }

    static {
        sessionField = ReflectionHelper.findMcpField(Minecraft.class, "field_71449_j");
        Preconditions.checkNotNull((Object)sessionField, (Object)"Reflection failed: field_71449_j");
        Class<YggdrasilUserAuthentication> clz = YggdrasilUserAuthentication.class;
        accessToken = ReflectionHelper.findField(clz, "accessToken");
        Preconditions.checkNotNull((Object)accessToken, (Object)"Reflection failed: accessToken");
        checkTokenValidity = ReflectionHelper.findMethod(clz, "checkTokenValidity", new Class[0]);
        Preconditions.checkNotNull((Object)checkTokenValidity, (Object)"Reflection failed: checkTokenValidity");
        logInWithPassword = ReflectionHelper.findMethod(clz, "logInWithPassword", new Class[0]);
        Preconditions.checkNotNull((Object)logInWithPassword, (Object)"Reflection failed: logInWithPassword");
        Constructor<YggdrasilUserAuthentication> constructor = ReflectionHelper.findConstructor(clz, YggdrasilAuthenticationService.class, String.class, Agent.class);
        if (constructor != null) {
            authParameterFactory = (authService, clientToken) -> new Object[]{authService, clientToken, Agent.MINECRAFT};
        } else {
            constructor = ReflectionHelper.findConstructor(clz, YggdrasilAuthenticationService.class, Agent.class);
            authParameterFactory = (authService, clientToken) -> new Object[]{authService, Agent.MINECRAFT};
        }
        Preconditions.checkNotNull(constructor, (Object)"Reflection failed: <init>");
        authConstructor = constructor;
    }

    public static enum SessionStatus {
        VALID("valid"),
        UNKNOWN("unknown"),
        REFRESHING("unknown"),
        INVALID("invalid");

        private final String translationKey;

        private SessionStatus(String translationKey) {
            this.translationKey = "reauth.status." + translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

