/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import vazkii.akashictome.AkashicTome;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.network.MessageUnmorphTome;
import vazkii.arl.util.ItemNBTHelper;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING = "akashictome:is_morphing";
    public static final String TAG_TOME_DATA = "akashictome:data";
    public static final String TAG_TOME_DISPLAY_NAME = "akashictome:displayName";
    public static final String TAG_ITEM_DEFINED_MOD = "akashictome:definedMod";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && MorphingHandler.isAkashicTome(stack) && stack.func_77973_b() != ModItems.tome) {
            AkashicTome.sendToServer(new MessageUnmorphTome());
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().func_226273_bm_()) {
            return;
        }
        ItemEntity e = event.getEntityItem();
        ItemStack stack = e.func_92059_d();
        if (!stack.func_190926_b() && MorphingHandler.isAkashicTome(stack) && stack.func_77973_b() != ModItems.tome) {
            ItemStack copy;
            CompoundNBT copyCmp;
            CompoundNBT morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA).func_74737_b();
            String currentMod = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_ITEM_DEFINED_MOD, (String)MorphingHandler.getModFromStack(stack));
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            CompoundNBT newMorphData = morph.func_77978_p().func_74775_l(TAG_TOME_DATA);
            newMorphData.func_82580_o(currentMod);
            if (!e.func_130014_f_().field_72995_K) {
                ItemEntity newItem = new ItemEntity(e.func_130014_f_(), e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), morph);
                e.func_130014_f_().func_217376_c((Entity)newItem);
            }
            if ((copyCmp = (copy = stack.func_77946_l()).func_77978_p()) == null) {
                copyCmp = new CompoundNBT();
                copy.func_77982_d(copyCmp);
            }
            copyCmp.func_82580_o("display");
            StringTextComponent displayName = null;
            CompoundNBT nameCmp = (CompoundNBT)copyCmp.func_74781_a(TAG_TOME_DISPLAY_NAME);
            if (nameCmp != null) {
                displayName = new StringTextComponent(nameCmp.func_74779_i("text"));
            }
            if (displayName != null && !displayName.getString().isEmpty() && displayName != copy.func_200301_q()) {
                copy.func_200302_a((ITextComponent)displayName);
            }
            copyCmp.func_82580_o(TAG_MORPHING);
            copyCmp.func_82580_o(TAG_TOME_DISPLAY_NAME);
            copyCmp.func_82580_o(TAG_TOME_DATA);
            e.func_92058_a(copy);
        }
    }

    public static String getModFromState(BlockState state) {
        return MorphingHandler.getModOrAlias(state.func_177230_c().getRegistryName().func_110624_b());
    }

    public static String getModFromStack(ItemStack stack) {
        return MorphingHandler.getModOrAlias(stack.func_190926_b() ? MINECRAFT : stack.func_77973_b().getCreatorModId(stack));
    }

    public static String getModOrAlias(String mod) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        for (String s : (List)ConfigHandler.aliasesList.get()) {
            if (!s.matches(".+?=.+")) continue;
            String[] tokens = s.toLowerCase().split("=");
            aliases.put(tokens[0], tokens[1]);
        }
        return aliases.getOrDefault(mod, mod);
    }

    public static boolean doesStackHaveModAttached(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return false;
        }
        CompoundNBT morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return morphData.func_74764_b(mod);
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        CompoundNBT morphData = stack.func_77978_p().func_74775_l(TAG_TOME_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, CompoundNBT morphData) {
        ItemStack stack;
        String currentMod = MorphingHandler.getModFromStack(currentStack);
        CompoundNBT currentCmp = new CompoundNBT();
        currentStack.func_77955_b(currentCmp);
        currentCmp = currentCmp.func_74737_b();
        if (currentCmp.func_74764_b("tag")) {
            currentCmp.func_74775_l("tag").func_82580_o(TAG_TOME_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("akashictome")) {
            morphData.func_218657_a(currentMod, (INBT)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack((IItemProvider)ModItems.tome);
        } else {
            CompoundNBT targetCmp = morphData.func_74775_l(targetMod);
            morphData.func_82580_o(targetMod);
            stack = ItemStack.func_199557_a((CompoundNBT)targetCmp);
            if (stack.func_190926_b()) {
                stack = new ItemStack((IItemProvider)ModItems.tome);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT stackCmp = stack.func_77978_p();
        stackCmp.func_218657_a(TAG_TOME_DATA, (INBT)morphData);
        stackCmp.func_74757_a(TAG_MORPHING, true);
        if (stack.func_77973_b() != ModItems.tome) {
            CompoundNBT displayName = new CompoundNBT();
            displayName.func_74778_a("text", stack.func_200301_q().getString());
            if (stackCmp.func_74764_b(TAG_TOME_DISPLAY_NAME)) {
                displayName = (CompoundNBT)stackCmp.func_74781_a(TAG_TOME_DISPLAY_NAME);
            } else {
                stackCmp.func_218657_a(TAG_TOME_DISPLAY_NAME, (INBT)displayName);
            }
            IFormattableTextComponent stackName = new StringTextComponent(displayName.func_74779_i("text")).func_230530_a_(Style.field_240709_b_.func_240720_a_(new TextFormatting[]{TextFormatting.GREEN}));
            TranslationTextComponent comp = new TranslationTextComponent("akashictome.sudo_name", new Object[]{stackName});
            stack.func_200302_a((ITextComponent)comp);
        }
        stack.func_190920_e(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        return modNames.containsKey(modId = modId.toLowerCase(Locale.ENGLISH)) ? modNames.get(modId) : modId;
    }

    public static boolean isAkashicTome(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.tome) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_MORPHING);
    }

    static {
        for (ModInfo modEntry : ModList.get().getMods()) {
            modNames.put(modEntry.getModId().toLowerCase(Locale.ENGLISH), modEntry.getDisplayName());
        }
    }
}

