/*
 * Decompiled with CFR 0.152.
 */
package shadows.menu.buttons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.menu.ExtendedMenuScreen;
import shadows.menu.buttons.ActionInstance;
import shadows.menu.buttons.AnchorPoint;
import shadows.menu.buttons.ButtonAction;

public class JsonButton
extends Button {
    protected ResourceLocation texture = field_230687_i_;
    protected int u;
    protected int v;
    protected int hoverU;
    protected int hoverV;
    protected int texWidth;
    protected int texHeight;
    protected final int xOff;
    protected final int yOff;
    protected boolean usesWidgets = false;
    protected String langKey;
    protected String hoverKey;
    protected final int fontColor;
    protected final int hoverFontColor;
    protected AnchorPoint anchor = AnchorPoint.DEFAULT;
    protected int textXOff;
    protected int textYOff;
    protected boolean dropShadow;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected int scrollCounter = 0;
    protected ITextComponent hoverMessage;

    public JsonButton(int xPos, int yPos, int width, int height, int fontColor, int hoverFontColor, String langKey, ActionInstance handler) {
        super(xPos, yPos, width, height, (ITextComponent)new TranslationTextComponent(langKey), (Button.IPressable)handler, Button.field_238486_s_);
        handler.setSource(this);
        this.xOff = xPos;
        this.yOff = yPos;
        this.langKey = langKey;
        this.fontColor = fontColor;
        this.hoverFontColor = hoverFontColor;
    }

    public JsonButton texture(ResourceLocation texture, int u, int v, int hoverU, int hoverV, int texWidth, int texHeight) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.hoverU = hoverU;
        this.hoverV = hoverV;
        this.texHeight = texHeight;
        this.texWidth = texWidth;
        return this;
    }

    public JsonButton anchor(AnchorPoint anchor) {
        this.anchor = anchor;
        return this;
    }

    public JsonButton usesWidgets(boolean widgets) {
        this.usesWidgets = widgets;
        return this;
    }

    public JsonButton textOffsets(int x, int y) {
        this.textXOff = x;
        this.textYOff = y;
        return this;
    }

    public JsonButton setup(ExtendedMenuScreen screen) {
        this.field_230690_l_ = this.xOff + this.anchor.getX(screen);
        this.field_230691_m_ = this.yOff + this.anchor.getY(screen);
        this.func_238482_a_((ITextComponent)new TranslationTextComponent(this.langKey));
        this.hoverMessage = new TranslationTextComponent(this.hoverKey);
        return this;
    }

    public JsonButton dropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public JsonButton scale(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
        return this;
    }

    public JsonButton hoverText(String hoverKey) {
        this.hoverKey = Strings.isNullOrEmpty((String)hoverKey) ? this.langKey : hoverKey;
        return this;
    }

    public ITextComponent func_230458_i_() {
        if (this.field_230692_n_) {
            return this.hoverMessage;
        }
        return super.func_230458_i_();
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partial) {
        if (this.field_230694_p_) {
            if (this.usesWidgets) {
                this.renderWidgetButton(stack, mouseX, mouseY, partial);
            } else {
                this.renderImageButton(stack, mouseX, mouseY, partial);
            }
        }
    }

    public static void drawCenteredStringNoShadow(MatrixStack stack, FontRenderer font, String string, int x, int y, int color) {
        font.func_238421_b_(stack, string, (float)(x - font.func_78256_a(string) / 2), (float)y, color);
    }

    public void drawCenteredString0(MatrixStack stack, FontRenderer font, String string, int x, int y, int color) {
        if (this.dropShadow) {
            Button.func_238471_a_((MatrixStack)stack, (FontRenderer)font, (String)string, (int)x, (int)y, (int)color);
        } else {
            JsonButton.drawCenteredStringNoShadow(stack, font, string, x, y, color);
        }
    }

    private void renderWidgetButton(MatrixStack stack, int mouseX, int mouseY, float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.texture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        int i = this.func_230989_a_(this.func_230449_g_());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.func_238474_b_(stack, this.field_230690_l_, this.field_230691_m_, 0, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_238474_b_(stack, this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_, 200 - this.field_230688_j_ / 2, 46 + i * 20, this.field_230688_j_ / 2, this.field_230689_k_);
        this.func_230441_a_(stack, mc, mouseX, mouseY);
        this.renderText(stack);
    }

    private void renderImageButton(MatrixStack stack, int mouseX, int mouseY, float partial) {
        Minecraft mc = Minecraft.func_71410_x();
        this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        mc.func_110434_K().func_110577_a(this.texture);
        RenderSystem.disableDepthTest();
        int x = this.u;
        int y = this.v;
        if (this.func_230449_g_()) {
            x = this.hoverU;
            y = this.hoverV;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        stack.func_227860_a_();
        stack.func_227862_a_(this.scaleX, this.scaleY, 1.0f);
        JsonButton.func_238463_a_((MatrixStack)stack, (int)Math.round((float)this.field_230690_l_ / this.scaleX), (int)Math.round((float)this.field_230691_m_ / this.scaleY), (float)x, (float)y, (int)Math.round((float)this.field_230688_j_ / this.scaleX), (int)Math.round((float)this.field_230689_k_ / this.scaleY), (int)this.texWidth, (int)this.texHeight);
        stack.func_227865_b_();
        RenderSystem.enableDepthTest();
        this.renderText(stack);
    }

    protected void renderText(MatrixStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        int color = this.getFGColor();
        String buttonText = this.func_230458_i_().getString();
        int strWidth = mc.field_71466_p.func_78256_a(buttonText);
        if (strWidth <= this.field_230688_j_ - 6) {
            this.drawCenteredString0(stack, mc.field_71466_p, buttonText, this.field_230690_l_ + this.field_230688_j_ / 2 + this.textXOff, this.field_230691_m_ + this.field_230689_k_ / 2 + this.textYOff, color);
        } else if (!this.field_230692_n_) {
            this.scrollCounter = 0;
            int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
            if (strWidth > ellipsisWidth) {
                buttonText = this.trimStringToWidth((ITextProperties)this.func_230458_i_(), this.field_230688_j_ - 6 - ellipsisWidth).getString().trim() + "...";
            }
            this.drawCenteredString0(stack, mc.field_71466_p, buttonText, this.field_230690_l_ + this.field_230688_j_ / 2 + this.textXOff, this.field_230691_m_ + this.field_230689_k_ / 2 + this.textYOff, color);
        } else {
            int halfLen = mc.field_71466_p.func_78256_a(buttonText + "      ");
            buttonText = buttonText + "      " + buttonText;
            stack.func_227860_a_();
            double d0 = mc.func_228018_at_().func_198100_s();
            float y = Minecraft.func_71410_x().field_71462_r.field_230709_l_ - this.field_230691_m_ - this.field_230689_k_;
            RenderSystem.enableScissor((int)((int)((double)this.field_230690_l_ * d0)), (int)((int)((double)y * d0)), (int)((int)(d0 * (double)this.field_230688_j_)), (int)((int)(d0 * (double)this.field_230689_k_)));
            stack.func_227861_a_((double)(((float)(-this.scrollCounter) - mc.func_193989_ak()) % (float)halfLen), 0.0, 0.0);
            if (this.dropShadow) {
                mc.field_71466_p.func_238405_a_(stack, buttonText, (float)(this.field_230690_l_ + this.field_230688_j_ / 8 + this.textXOff), (float)(this.field_230691_m_ + this.field_230689_k_ / 2 + this.textYOff), color);
            } else {
                mc.field_71466_p.func_238421_b_(stack, buttonText, (float)(this.field_230690_l_ + this.field_230688_j_ / 8 + this.textXOff), (float)(this.field_230691_m_ + this.field_230689_k_ / 2 + this.textYOff), color);
            }
            RenderSystem.disableScissor();
            stack.func_227865_b_();
        }
    }

    public void tickScrollCounter() {
        ++this.scrollCounter;
    }

    public ITextProperties trimStringToWidth(ITextProperties str, int width) {
        return (ITextProperties)Minecraft.func_71410_x().field_71466_p.func_238420_b_().func_238362_b_(str, width, Style.field_240709_b_).get(0);
    }

    public int getFGColor() {
        return !this.field_230692_n_ ? this.fontColor : this.hoverFontColor;
    }

    public static JsonButton deserialize(JsonObject obj) {
        JsonElement x = obj.get("x");
        JsonElement y = obj.get("y");
        JsonElement width = obj.get("width");
        JsonElement height = obj.get("height");
        JsonElement tex = obj.get("texture");
        JsonElement u = obj.get("u");
        JsonElement v = obj.get("v");
        JsonElement hoverU = obj.get("hoverU");
        JsonElement hoverV = obj.get("hoverV");
        JsonElement texWidth = obj.get("texWidth");
        JsonElement texHeight = obj.get("texHeight");
        JsonElement widgets = obj.get("widgets");
        JsonElement langKey = obj.get("langKey");
        JsonElement hoverLangKey = obj.get("hoverLangKey");
        JsonElement action = obj.get("action");
        JsonElement fontColor = obj.get("fontColor");
        JsonElement hoverFontColor = obj.get("hoverFontColor");
        JsonElement anchor = obj.get("anchor");
        JsonElement textX = obj.get("textXOffset");
        JsonElement textY = obj.get("textYOffset");
        JsonElement dropShadow = obj.get("dropShadow");
        JsonElement active = obj.get("active");
        JsonElement scaleX = obj.get("scaleX");
        JsonElement scaleY = obj.get("scaleY");
        ResourceLocation _tex = tex == null ? field_230687_i_ : new ResourceLocation(tex.getAsString());
        int _u = JsonButton.get(u, 0);
        int _v = JsonButton.get(v, 0);
        int _hoverU = JsonButton.get(hoverU, 0);
        int _hoverV = JsonButton.get(hoverV, 0);
        int _x = JsonButton.get(x, 0);
        int _y = JsonButton.get(y, 0);
        int _width = JsonButton.get(width, 0);
        int _height = JsonButton.get(height, 0);
        int _texWidth = JsonButton.get(texWidth, 256);
        int _texHeight = JsonButton.get(texHeight, 256);
        boolean _widgets = widgets == null ? _tex.toString().contains("widgets") : widgets.getAsBoolean();
        int _fontColor = JsonButton.get(fontColor, 0xFFFFFF);
        int _hoverFontColor = JsonButton.get(hoverFontColor, 0xFFFFFF);
        String displayKey = langKey == null ? "" : langKey.getAsString();
        String hoverKey = hoverLangKey == null ? "" : hoverLangKey.getAsString();
        ButtonAction act = ButtonAction.valueOf(action.getAsString().toUpperCase(Locale.ROOT));
        AnchorPoint _anchor = anchor == null ? AnchorPoint.DEFAULT : AnchorPoint.valueOf(anchor.getAsString());
        Object data = act.readData(obj);
        int _textX = JsonButton.get(textX, 0);
        int _textY = JsonButton.get(textY, -4);
        float _scaleX = JsonButton.get(scaleX, 1.0f);
        float _scaleY = JsonButton.get(scaleY, 1.0f);
        boolean _dropShadow = dropShadow == null ? true : dropShadow.getAsBoolean();
        JsonButton button = new JsonButton(_x, _y, _width, _height, _fontColor, _hoverFontColor, displayKey, new ActionInstance(act, data));
        button.texture(_tex, _u, _v, _hoverU, _hoverV, _texWidth, _texHeight).usesWidgets(_widgets).anchor(_anchor);
        button.textOffsets(_textX, _textY).dropShadow(_dropShadow).scale(_scaleX, _scaleY).hoverText(hoverKey);
        button.field_230693_o_ = active == null ? true : active.getAsBoolean();
        return button;
    }

    private static int get(JsonElement e, int def) {
        return e == null ? def : e.getAsInt();
    }

    private static float get(JsonElement e, float def) {
        return e == null ? def : e.getAsFloat();
    }
}

