/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.mantle.registration.deferred.ContainerTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.EntityTypeDeferredRegister;
import slimeknights.mantle.registration.deferred.TileEntityTypeDeferredRegister;
import slimeknights.mantle.util.SupplierItemGroup;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.registration.BlockDeferredRegisterExtension;
import slimeknights.tconstruct.common.registration.FluidDeferredRegisterExtension;
import slimeknights.tconstruct.common.registration.ItemDeferredRegisterExtension;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.SlimeType;

public abstract class TinkerModule {
    protected static final BlockDeferredRegisterExtension BLOCKS = new BlockDeferredRegisterExtension("tconstruct");
    protected static final ItemDeferredRegisterExtension ITEMS = new ItemDeferredRegisterExtension("tconstruct");
    protected static final FluidDeferredRegisterExtension FLUIDS = new FluidDeferredRegisterExtension("tconstruct");
    protected static final TileEntityTypeDeferredRegister TILE_ENTITIES = new TileEntityTypeDeferredRegister("tconstruct");
    protected static final EntityTypeDeferredRegister ENTITIES = new EntityTypeDeferredRegister("tconstruct");
    protected static final ContainerTypeDeferredRegister CONTAINERS = new ContainerTypeDeferredRegister("tconstruct");
    protected static final DeferredRegister<Effect> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"tconstruct");
    protected static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tconstruct");
    protected static final DeferredRegister<Structure<?>> STRUCTURE_FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"tconstruct");
    protected static final DeferredRegister<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_STATE_PROVIDER_TYPES, (String)"tconstruct");
    protected static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"tconstruct");
    protected static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tconstruct");
    protected static final DeferredRegister<Modifier> MODIFIERS = DeferredRegister.create(Modifier.class, (String)"tconstruct");
    protected static final DeferredRegister<GlobalLootModifierSerializer<?>> GLOBAL_LOOT_MODIFIERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"tconstruct");
    public static final ItemGroup TAB_GENERAL = new SupplierItemGroup("tconstruct", "general", () -> new ItemStack((IItemProvider)TinkerCommons.slimeball.get((Enum)SlimeType.SKY)));
    protected static final Item.Properties HIDDEN_PROPS = new Item.Properties();
    protected static final Item.Properties GENERAL_PROPS = new Item.Properties().func_200916_a(TAB_GENERAL);
    protected static final Function<Block, ? extends BlockItem> HIDDEN_BLOCK_ITEM = b -> new BlockItem(b, HIDDEN_PROPS);
    protected static final Function<Block, ? extends BlockItem> GENERAL_BLOCK_ITEM = b -> new BlockItem(b, GENERAL_PROPS);
    protected static final Function<Block, ? extends BlockItem> GENERAL_TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, GENERAL_PROPS);
    protected static final Supplier<Item> TOOLTIP_ITEM = () -> new TooltipItem(GENERAL_PROPS);
    protected static final ToolType NO_TOOL = null;

    public static void initRegisters() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FLUIDS.register(bus);
        TILE_ENTITIES.register(bus);
        ENTITIES.register(bus);
        CONTAINERS.register(bus);
        POTIONS.register(bus);
        FEATURES.register(bus);
        STRUCTURE_FEATURES.register(bus);
        BLOCK_STATE_PROVIDER_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        PARTICLE_TYPES.register(bus);
        MODIFIERS.register(bus);
        GLOBAL_LOOT_MODIFIERS.register(bus);
    }

    @Nonnull
    public static <T> T injected() {
        return null;
    }

    protected static AbstractBlock.Properties builder(Material material, @Nullable ToolType toolType, SoundType soundType) {
        return AbstractBlock.Properties.func_200945_a((Material)material).harvestTool(toolType).func_200947_a(soundType);
    }

    protected static AbstractBlock.Properties builder(Material material, MaterialColor color, @Nullable ToolType toolType, SoundType soundType) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).harvestTool(toolType).func_200947_a(soundType);
    }

    protected static AbstractBlock.Properties metalBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.field_151573_f, color, ToolType.PICKAXE, SoundType.field_185852_e).func_235861_h_().func_200943_b(5.0f);
    }

    protected static AbstractBlock.Properties glassBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.field_151592_s, ToolType.PICKAXE, SoundType.field_185853_f).func_235861_h_().func_200943_b(0.3f).func_226896_b_().func_235827_a_(Blocks::func_235427_a_).func_235828_a_(Blocks::func_235436_b_).func_235842_b_(Blocks::func_235436_b_).func_235847_c_(Blocks::func_235436_b_);
    }

    protected static AbstractBlock.Properties woodBuilder(MaterialColor color) {
        return TinkerModule.builder(Material.field_151575_d, color, ToolType.AXE, SoundType.field_185848_a).func_235861_h_().func_200948_a(2.0f, 7.0f);
    }

    protected static ResourceLocation resource(String path) {
        return TConstruct.getResource(path);
    }
}

