/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.tags;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.MetalItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockTagProvider
extends BlockTagsProvider {
    public BlockTagProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "tconstruct", existingFileHelper);
    }

    protected void func_200432_c() {
        this.addCommon();
        this.addTools();
        this.addWorld();
        this.addSmeltery();
        this.addFluids();
    }

    private void addCommon() {
        this.addMetalTags(TinkerMaterials.copper);
        this.addMetalTags(TinkerMaterials.cobalt);
        this.addMetalTags(TinkerMaterials.slimesteel);
        this.addMetalTags(TinkerMaterials.tinkersBronze);
        this.addMetalTags(TinkerMaterials.roseGold);
        this.addMetalTags(TinkerMaterials.pigIron);
        this.addMetalTags(TinkerMaterials.queensSlime);
        this.addMetalTags(TinkerMaterials.manyullyn);
        this.addMetalTags(TinkerMaterials.hepatizon);
        this.addMetalTags(TinkerMaterials.soulsteel);
        this.addMetalTags(TinkerMaterials.knightslime);
        this.func_240522_a_(BlockTags.field_232875_ap_).func_240534_a_((Object[])new Block[]{(Block)TinkerModifiers.silkyJewelBlock.get()});
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.GLASS_COLORLESS).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.clearGlass.get()});
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.GLASS_PANES_COLORLESS).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.clearGlassPane.get()});
        this.addGlass(TinkerCommons.clearStainedGlass, "glass/", (TagsProvider.Builder<Block>)this.func_240522_a_((ITag.INamedTag)Tags.Blocks.STAINED_GLASS));
        this.addGlass(TinkerCommons.clearStainedGlassPane, "glass_panes/", (TagsProvider.Builder<Block>)this.func_240522_a_((ITag.INamedTag)Tags.Blocks.STAINED_GLASS_PANES));
        TagsProvider.Builder impermeable = this.func_240522_a_(BlockTags.field_211923_H);
        impermeable.func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.clearGlass.get(), (Block)TinkerCommons.soulGlass.get(), (Block)TinkerSmeltery.searedGlass.get()});
        TinkerCommons.clearStainedGlass.forEach(arg_0 -> ((TagsProvider.Builder)impermeable).func_240532_a_(arg_0));
        this.func_240522_a_(BlockTags.field_232876_aq_).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get(), (Block)TinkerCommons.soulGlassPane.get()});
        this.func_240522_a_(BlockTags.field_232880_av_).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.soulGlass.get()});
        TagsProvider.Builder builder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.ANVIL_METAL).func_240531_a_(TinkerMaterials.slimesteel.getBlockTag()).func_240531_a_(TinkerMaterials.tinkersBronze.getBlockTag()).func_240531_a_(TinkerMaterials.roseGold.getBlockTag()).func_240531_a_(TinkerMaterials.pigIron.getBlockTag()).func_240531_a_(TinkerMaterials.queensSlime.getBlockTag()).func_240531_a_(TinkerMaterials.manyullyn.getBlockTag()).func_240531_a_(TinkerMaterials.hepatizon.getBlockTag()).func_240531_a_((ITag.INamedTag)Tags.Blocks.STORAGE_BLOCKS_NETHERITE);
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            if (compat.isOre()) continue;
            builder.addOptionalTag(new ResourceLocation("forge", "storage_blocks/" + compat.getName()));
        }
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.PLANKLIKE).func_240531_a_(BlockTags.field_199898_b).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.lavawood.get(), (Block)TinkerCommons.blazewood.get(), (Block)TinkerMaterials.nahuatl.get()});
    }

    private void addTools() {
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.WORKBENCHES).func_240534_a_((Object[])new Block[]{Blocks.field_150462_ai, (Block)TinkerTables.craftingStation.get()}).addOptionalTag(new ResourceLocation("forge:workbench"));
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.TABLES).func_240534_a_((Object[])new Block[]{(Block)TinkerTables.craftingStation.get(), (Block)TinkerTables.partBuilder.get(), (Block)TinkerTables.tinkerStation.get()});
        this.func_240522_a_(BlockTags.field_232883_ay_).func_240534_a_((Object[])new Block[]{(Block)TinkerModifiers.silkyJewelBlock.get()}).func_240531_a_(TinkerMaterials.roseGold.getBlockTag());
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.HARVESTABLE_STACKABLE).func_240534_a_((Object[])new Block[]{Blocks.field_196608_cF, Blocks.field_203215_jy});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.HARVESTABLE_CROPS).func_240531_a_(BlockTags.field_226152_ab_).addOptionalTag(new ResourceLocation("forge", "crops")).func_240534_a_((Object[])new Block[]{Blocks.field_150388_bm});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.HARVESTABLE_INTERACT).func_240534_a_((Object[])new Block[]{Blocks.field_222434_lW});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.HARVESTABLE).func_240534_a_((Object[])new Block[]{Blocks.field_150423_aK, Blocks.field_226906_mb_, Blocks.field_226905_ma_}).func_240531_a_(TinkerTags.Blocks.HARVESTABLE_CROPS).func_240531_a_(TinkerTags.Blocks.HARVESTABLE_INTERACT).func_240531_a_(TinkerTags.Blocks.HARVESTABLE_STACKABLE);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.TREE_LOGS).func_240531_a_(BlockTags.field_200031_h);
    }

    private void addWorld() {
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.ORES_COBALT).func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.cobaltOre.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.ORES_COPPER).func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.copperOre.get()});
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.ORES).func_240531_a_(TinkerTags.Blocks.ORES_COBALT).func_240531_a_(TinkerTags.Blocks.ORES_COPPER);
        TagsProvider.Builder endermanHoldable = this.func_240522_a_(BlockTags.field_201151_l);
        endermanHoldable.func_240531_a_(TinkerTags.Blocks.CONGEALED_SLIME).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.grout.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_LOGS).func_240531_a_((ITag.INamedTag)TinkerWorld.greenheart.getLogBlockTag()).func_240531_a_((ITag.INamedTag)TinkerWorld.skyroot.getLogBlockTag()).func_240531_a_((ITag.INamedTag)TinkerWorld.bloodshroom.getLogBlockTag());
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_PLANKS).func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.greenheart.get(), (Block)TinkerWorld.skyroot.get(), (Block)TinkerWorld.bloodshroom.get()});
        this.func_240522_a_(BlockTags.field_199898_b).func_240531_a_(TinkerTags.Blocks.SLIMY_PLANKS);
        this.func_240522_a_(BlockTags.field_200031_h).func_240531_a_(TinkerTags.Blocks.SLIMY_LOGS);
        this.addWoodTags(TinkerWorld.greenheart, true);
        this.addWoodTags(TinkerWorld.skyroot, true);
        this.addWoodTags(TinkerWorld.bloodshroom, false);
        TagsProvider.Builder slimeBlockBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIME_BLOCK);
        TagsProvider.Builder congealedBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.CONGEALED_SLIME);
        for (SlimeType slimeType : SlimeType.values()) {
            slimeBlockBuilder.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.slime.get((Enum)slimeType)});
            congealedBuilder.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.congealedSlime.get((Enum)slimeType)});
        }
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_TREE_TRUNKS).func_240531_a_(TinkerTags.Blocks.SLIMY_LOGS).func_240531_a_(TinkerTags.Blocks.CONGEALED_SLIME);
        TagsProvider.Builder leavesBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_LEAVES);
        TagsProvider.Builder wartBuilder = this.func_240522_a_(BlockTags.field_232874_ao_);
        TagsProvider.Builder saplingBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_SAPLINGS);
        for (SlimeType type3 : SlimeType.values()) {
            if (type3.isNether()) {
                wartBuilder.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.slimeLeaves.get((Enum)type3)});
                endermanHoldable.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.slimeSapling.get((Enum)type3)});
                continue;
            }
            leavesBuilder.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.slimeLeaves.get((Enum)type3)});
            saplingBuilder.func_240534_a_((Object[])new Block[]{(Block)TinkerWorld.slimeSapling.get((Enum)type3)});
        }
        this.func_240522_a_(BlockTags.field_206952_E).func_240531_a_(TinkerTags.Blocks.SLIMY_LEAVES);
        this.func_240522_a_(BlockTags.field_200030_g).func_240531_a_(TinkerTags.Blocks.SLIMY_SAPLINGS);
        TagsProvider.Builder builder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_GRASS);
        TagsProvider.Builder slimyNylium = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_NYLIUM);
        TagsProvider.Builder slimySoil = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SLIMY_SOIL);
        for (SlimeType type4 : SlimeType.values()) {
            (type4.isNether() ? slimyNylium : builder).func_240531_a_(type4.getGrassBlockTag());
            slimySoil.func_240531_a_(type4.getDirtBlockTag());
        }
        TinkerWorld.slimeGrass.forEach((dirtType, blockObj) -> blockObj.forEach((grassType, block) -> {
            this.func_240522_a_((ITag.INamedTag)grassType.getGrassBlockTag()).func_240534_a_((Object[])new Block[]{block});
            this.func_240522_a_((ITag.INamedTag)dirtType.getDirtBlockTag()).func_240534_a_((Object[])new Block[]{block});
        }));
        TinkerWorld.slimeDirt.forEach((type, block) -> this.func_240522_a_((ITag.INamedTag)type.getDirtBlockTag()).func_240534_a_((Object[])new Block[]{block}));
        endermanHoldable.func_240531_a_(TinkerTags.Blocks.SLIMY_SOIL);
    }

    private void addSmeltery() {
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SEARED_BRICKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedBricks.get(), (Block)TinkerSmeltery.searedFancyBricks.get(), (Block)TinkerSmeltery.searedTriangleBricks.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SEARED_BLOCKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedStone.get(), (Block)TinkerSmeltery.searedCrackedBricks.get(), (Block)TinkerSmeltery.searedCobble.get(), (Block)TinkerSmeltery.searedPaver.get()}).func_240531_a_(TinkerTags.Blocks.SEARED_BRICKS);
        this.func_240522_a_(BlockTags.field_219757_z).func_240534_a_((Object[])new Block[]{TinkerSmeltery.searedBricks.getWall(), TinkerSmeltery.searedCobble.getWall()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SCORCHED_BLOCKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedStone.get(), (Block)TinkerSmeltery.polishedScorchedStone.get(), (Block)TinkerSmeltery.scorchedBricks.get(), (Block)TinkerSmeltery.scorchedRoad.get(), (Block)TinkerSmeltery.chiseledScorchedBricks.get()});
        this.func_240522_a_(BlockTags.field_219748_G).func_240534_a_((Object[])new Block[]{TinkerSmeltery.scorchedBricks.getFence(), TinkerMaterials.nahuatl.getFence()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.CISTERN_CONNECTIONS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedFaucet.get(), (Block)TinkerSmeltery.scorchedFaucet.get()});
        TagsProvider.Builder searedTankBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SEARED_TANKS);
        TinkerSmeltery.searedTank.forEach(arg_0 -> ((TagsProvider.Builder)searedTankBuilder).func_240532_a_(arg_0));
        TagsProvider.Builder scorchedTankBuilder = this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SCORCHED_TANKS);
        TinkerSmeltery.scorchedTank.forEach(arg_0 -> ((TagsProvider.Builder)scorchedTankBuilder).func_240532_a_(arg_0));
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.HEATER_CONTROLLERS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedMelter.get(), (Block)TinkerSmeltery.scorchedAlloyer.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.FUEL_TANKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedHeater.get()}).func_240531_a_(TinkerTags.Blocks.SEARED_TANKS).func_240531_a_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SMELTERY_TANKS).func_240531_a_(TinkerTags.Blocks.SEARED_TANKS);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.FOUNDRY_TANKS).func_240531_a_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.ALLOYER_TANKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedAlloyer.get(), (Block)TinkerSmeltery.searedMelter.get()}).func_240531_a_(TinkerTags.Blocks.SEARED_TANKS).func_240531_a_(TinkerTags.Blocks.SCORCHED_TANKS);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SMELTERY_FLOOR).func_240531_a_(TinkerTags.Blocks.SEARED_BLOCKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SMELTERY_WALL).func_240531_a_(TinkerTags.Blocks.SEARED_BLOCKS).func_240531_a_(TinkerTags.Blocks.SMELTERY_TANKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedGlass.get(), (Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.searedDrain.get(), (Block)TinkerSmeltery.searedChute.get(), (Block)TinkerSmeltery.searedDuct.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.SMELTERY).func_240531_a_(TinkerTags.Blocks.SMELTERY_WALL).func_240531_a_(TinkerTags.Blocks.SMELTERY_FLOOR).func_240531_a_(TinkerTags.Blocks.SMELTERY_TANKS);
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.FOUNDRY_FLOOR).func_240531_a_(TinkerTags.Blocks.SCORCHED_BLOCKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.FOUNDRY_WALL).func_240531_a_(TinkerTags.Blocks.SCORCHED_BLOCKS).func_240531_a_(TinkerTags.Blocks.FOUNDRY_TANKS).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.scorchedGlass.get(), (Block)TinkerSmeltery.scorchedLadder.get(), (Block)TinkerSmeltery.scorchedDrain.get(), (Block)TinkerSmeltery.scorchedChute.get(), (Block)TinkerSmeltery.scorchedDuct.get()});
        this.func_240522_a_((ITag.INamedTag)TinkerTags.Blocks.FOUNDRY).func_240531_a_(TinkerTags.Blocks.FOUNDRY_WALL).func_240531_a_(TinkerTags.Blocks.FOUNDRY_FLOOR).func_240531_a_(TinkerTags.Blocks.FOUNDRY_TANKS);
        this.func_240522_a_(BlockTags.field_232878_as_).func_240534_a_((Object[])new Block[]{(Block)TinkerSmeltery.searedLadder.get(), (Block)TinkerSmeltery.scorchedLadder.get()});
        this.func_240522_a_(BlockTags.field_219754_W).func_240534_a_((Object[])new Block[]{(Block)TinkerCommons.obsidianPane.get()});
    }

    private void addFluids() {
        this.func_240522_a_(BlockTags.field_232881_aw_).func_240534_a_((Object[])new Block[]{TinkerFluids.magma.getBlock(), TinkerFluids.blazingBlood.getBlock()});
    }

    public String func_200397_b() {
        return "Tinkers Construct Block Tags";
    }

    private void addMetalTags(MetalItemObject metal) {
        this.func_240522_a_((ITag.INamedTag)metal.getBlockTag()).func_240534_a_((Object[])new Block[]{(Block)metal.get()});
        this.func_240522_a_(BlockTags.field_232875_ap_).func_240531_a_(metal.getBlockTag());
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.STORAGE_BLOCKS).func_240531_a_(metal.getBlockTag());
    }

    private void addGlass(EnumObject<ClearStainedGlassBlock.GlassColor, ? extends Block> blockObj, String tagPrefix, TagsProvider.Builder<Block> blockTag) {
        blockObj.forEach((color, block) -> {
            blockTag.func_240534_a_((Object[])new Block[]{block});
            this.func_240522_a_((ITag.INamedTag)BlockTags.createOptional((ResourceLocation)new ResourceLocation("forge", tagPrefix + (Object)color))).func_240534_a_((Object[])new Block[]{block});
        });
    }

    private void addWoodTags(WoodBlockObject object, boolean doesBurn) {
        this.func_240522_a_(BlockTags.field_202895_i).func_240534_a_((Object[])new Block[]{object.getSlab()});
        this.func_240522_a_(BlockTags.field_202894_h).func_240534_a_((Object[])new Block[]{object.getStairs()});
        this.func_240522_a_((ITag.INamedTag)object.getLogBlockTag()).func_240534_a_((Object[])new Block[]{object.getLog(), object.getStrippedLog(), object.getWood(), object.getStrippedWood()});
        this.func_240522_a_(BlockTags.field_219756_j).func_240534_a_((Object[])new Block[]{object.getFence()});
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.FENCES_WOODEN).func_240534_a_((Object[])new Block[]{object.getFence()});
        this.func_240522_a_(BlockTags.field_232868_aA_).func_240534_a_((Object[])new Block[]{object.getFenceGate()});
        this.func_240522_a_((ITag.INamedTag)Tags.Blocks.FENCE_GATES_WOODEN).func_240534_a_((Object[])new Block[]{object.getFenceGate()});
        this.func_240522_a_(BlockTags.field_200152_g).func_240534_a_((Object[])new Block[]{object.getDoor()});
        this.func_240522_a_(BlockTags.field_212186_k).func_240534_a_((Object[])new Block[]{object.getTrapdoor()});
        this.func_240522_a_(BlockTags.field_200151_d).func_240534_a_((Object[])new Block[]{object.getButton()});
        this.func_240522_a_(BlockTags.field_202896_j).func_240534_a_((Object[])new Block[]{object.getPressurePlate()});
        if (doesBurn) {
            this.func_240522_a_(BlockTags.field_232887_q_).func_240531_a_((ITag.INamedTag)object.getLogBlockTag());
        } else {
            this.func_240522_a_(BlockTags.field_232867_Q_).func_240534_a_((Object[])new Block[]{(Block)object.get(), object.getSlab(), object.getStairs(), object.getFence(), object.getFenceGate(), object.getDoor(), object.getTrapdoor(), object.getPressurePlate(), object.getButton()}).func_240531_a_((ITag.INamedTag)object.getLogBlockTag());
        }
        this.func_240522_a_(BlockTags.field_219751_T).func_240534_a_((Object[])new Block[]{object.getSign()});
        this.func_240522_a_(BlockTags.field_219752_U).func_240534_a_((Object[])new Block[]{object.getWallSign()});
    }
}

