/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;

@OnlyIn(value=Dist.CLIENT)
public class ContentListingSectionTransformer
extends SectionTransformer {
    public ContentListingSectionTransformer(String sectionName) {
        super(sectionName);
    }

    @Override
    public void transform(BookData book, SectionData data) {
        ContentListing listing = new ContentListing();
        listing.title = book.translate(this.sectionName);
        String subtextKey = this.sectionName + ".subtext";
        if (book.strings.containsKey(subtextKey)) {
            listing.subText = book.translate(subtextKey);
        }
        PageData listingPage = new PageData(true);
        listingPage.name = this.sectionName;
        listingPage.source = data.source;
        listingPage.parent = data;
        listingPage.content = listing;
        data.pages.forEach(sectionPage -> this.processPage(book, listing, (PageData)sectionPage));
        if (listing.hasEntries()) {
            listingPage.load();
            data.pages.add(0, listingPage);
        }
    }

    protected void processPage(BookData book, ContentListing listing, PageData page) {
        if (!page.getTitle().equals("hidden")) {
            listing.addEntry(book.translate(page.getTitle()), page);
        }
    }
}

