/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public abstract class TinkerToolEvent
extends Event {
    private final ItemStack stack;
    private final IModifierToolStack tool;

    public TinkerToolEvent(ItemStack stack) {
        this.stack = stack;
        this.tool = ToolStack.from(stack);
    }

    public TinkerToolEvent(ItemStack stack, IModifierToolStack tool) {
        this.stack = stack;
        this.tool = tool;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IModifierToolStack getTool() {
        return this.tool;
    }

    @Event.HasResult
    public static class ToolShearEvent
    extends TinkerToolEvent {
        private final World world;
        private final PlayerEntity player;
        private final Entity target;
        private final int fortune;

        public ToolShearEvent(ItemStack stack, IModifierToolStack tool, World world, PlayerEntity player, Entity target, int fortune) {
            super(stack, tool);
            this.world = world;
            this.player = player;
            this.target = target;
            this.fortune = fortune;
        }

        public Event.Result fire() {
            MinecraftForge.EVENT_BUS.post((Event)this);
            return this.getResult();
        }

        public World getWorld() {
            return this.world;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public Entity getTarget() {
            return this.target;
        }

        public int getFortune() {
            return this.fortune;
        }
    }

    @Event.HasResult
    public static class ToolHarvestEvent
    extends TinkerToolEvent {
        private final ItemUseContext context;
        private final ServerWorld world;
        private final BlockState state;
        private final BlockPos pos;
        @Nullable
        private final PlayerEntity player;

        public ToolHarvestEvent(ItemStack stack, IModifierToolStack tool, ItemUseContext context, ServerWorld world, BlockState state, BlockPos pos, @Nullable PlayerEntity player) {
            super(stack, tool);
            this.context = context;
            this.world = world;
            this.state = state;
            this.pos = pos;
            this.player = player;
        }

        public Event.Result fire() {
            MinecraftForge.EVENT_BUS.post((Event)this);
            return this.getResult();
        }

        public ItemUseContext getContext() {
            return this.context;
        }

        public ServerWorld getWorld() {
            return this.world;
        }

        public BlockState getState() {
            return this.state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        @Nullable
        public PlayerEntity getPlayer() {
            return this.player;
        }
    }
}

