/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class UpdateMaterialsPacket
implements IThreadsafePacket {
    private final Collection<IMaterial> materials;
    private final Map<MaterialId, MaterialId> redirects;

    public UpdateMaterialsPacket(PacketBuffer buffer) {
        int materialCount = buffer.readInt();
        this.materials = new ArrayList<IMaterial>(materialCount);
        for (int i = 0; i < materialCount; ++i) {
            MaterialId id = new MaterialId(buffer.func_192575_l());
            int tier = buffer.func_150792_a();
            int sortOrder = buffer.func_150792_a();
            boolean craftable = buffer.readBoolean();
            int color = buffer.readInt();
            boolean hidden = buffer.readBoolean();
            this.materials.add(new Material(id, tier, sortOrder, craftable, Color.func_240743_a_((int)color), hidden));
        }
        int redirectCount = buffer.func_150792_a();
        if (redirectCount == 0) {
            this.redirects = Collections.emptyMap();
        } else {
            this.redirects = new HashMap<MaterialId, MaterialId>(redirectCount);
            for (int i = 0; i < redirectCount; ++i) {
                this.redirects.put(new MaterialId(buffer.func_218666_n()), new MaterialId(buffer.func_218666_n()));
            }
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.materials.size());
        this.materials.forEach(material -> {
            buffer.func_192572_a((ResourceLocation)material.getIdentifier());
            buffer.func_150787_b(material.getTier());
            buffer.func_150787_b(material.getSortOrder());
            buffer.writeBoolean(material.isCraftable());
            buffer.writeInt(material.getColor().field_240740_c_);
            buffer.writeBoolean(material.isHidden());
        });
        buffer.func_150787_b(this.redirects.size());
        this.redirects.forEach((key, value) -> {
            buffer.func_180714_a(key.toString());
            buffer.func_180714_a(value.toString());
        });
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        MaterialRegistry.updateMaterialsFromServer(this);
    }

    public Collection<IMaterial> getMaterials() {
        return this.materials;
    }

    public Map<MaterialId, MaterialId> getRedirects() {
        return this.redirects;
    }

    public UpdateMaterialsPacket(Collection<IMaterial> materials, Map<MaterialId, MaterialId> redirects) {
        this.materials = materials;
        this.redirects = redirects;
    }
}

