/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialIngredient
extends Ingredient {
    private static final MaterialId WILDCARD = IMaterial.UNKNOWN.getIdentifier();
    private final MaterialId materialID;
    @Nullable
    private ItemStack[] materialStacks;

    protected MaterialIngredient(Stream<? extends Ingredient.IItemList> itemLists, MaterialId material) {
        super(itemLists);
        this.materialID = material;
    }

    public static MaterialIngredient fromItem(IMaterialItem item, MaterialId material) {
        return new MaterialIngredient(Stream.of(new Ingredient.SingleItemList(new ItemStack((IItemProvider)item))), material);
    }

    public static MaterialIngredient fromItem(IMaterialItem item) {
        return MaterialIngredient.fromItem(item, WILDCARD);
    }

    public static MaterialIngredient fromTag(ITag<Item> tag, MaterialId material) {
        return new MaterialIngredient(Stream.of(new Ingredient.TagList(tag)), material);
    }

    public static MaterialIngredient fromTag(ITag<Item> tag) {
        return MaterialIngredient.fromTag(tag, WILDCARD);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (!WILDCARD.equals((Object)this.materialID) && !this.materialID.equals((Object)IMaterialItem.getMaterialFromStack(stack).getIdentifier())) {
            return false;
        }
        return super.test(stack);
    }

    public ItemStack[] func_193365_a() {
        if (this.materialStacks == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return this.getPlainMatchingStacks();
            }
            Stream<Object> items = Arrays.stream(this.getPlainMatchingStacks());
            if (this.materialID.equals((Object)WILDCARD)) {
                items = items.flatMap(stack -> MaterialRegistry.getMaterials().stream().map(mat -> IMaterialItem.withMaterial(stack, mat)).filter(ItemStack::func_77942_o));
            } else {
                IMaterial material = MaterialRegistry.getMaterial(this.materialID);
                items = items.map(stack -> IMaterialItem.withMaterial(stack, material)).filter(ItemStack::func_77942_o);
            }
            this.materialStacks = (ItemStack[])items.distinct().toArray(ItemStack[]::new);
        }
        return this.materialStacks;
    }

    private ItemStack[] getPlainMatchingStacks() {
        return super.func_193365_a();
    }

    public JsonElement func_200304_c() {
        JsonElement parent = super.func_200304_c();
        if (!parent.isJsonObject()) {
            throw new JsonIOException("Cannot serialize an array of material ingredients, use CompoundIngredient instead");
        }
        JsonObject object = parent.getAsJsonObject();
        object.addProperty("type", Serializer.ID.toString());
        if (this.materialID != WILDCARD) {
            object.addProperty("material", this.materialID.toString());
        }
        return object;
    }

    protected void invalidate() {
        super.invalidate();
        this.materialStacks = null;
    }

    public boolean isSimple() {
        return this.materialID == WILDCARD && super.isSimple();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<MaterialIngredient> {
        public static final ResourceLocation ID = TConstruct.getResource("material");
        public static final Serializer INSTANCE = new Serializer();

        public MaterialIngredient parse(JsonObject json) {
            MaterialId material = json.has("material") ? new MaterialId(JSONUtils.func_151200_h((JsonObject)json, (String)"material")) : WILDCARD;
            return new MaterialIngredient(Stream.of(Ingredient.func_199803_a((JsonObject)json)), material);
        }

        public MaterialIngredient parse(PacketBuffer buffer) {
            MaterialId material = new MaterialId(buffer.func_192575_l());
            return new MaterialIngredient(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()), material);
        }

        public void write(PacketBuffer buffer, MaterialIngredient ingredient) {
            buffer.func_192572_a((ResourceLocation)ingredient.materialID);
            ItemStack[] items = ingredient.getPlainMatchingStacks();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        private Serializer() {
        }
    }
}

