/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class DamageableMeltingRecipe
extends MeltingRecipe {
    public DamageableMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        super(id, group, input, output, temperature, time, byproducts);
    }

    private static FluidStack scaleOutput(FluidStack fluid, int damage, int maxDamage) {
        return new FluidStack(fluid, Math.max(fluid.getAmount() * (maxDamage - damage) / maxDamage, 1));
    }

    @Override
    public FluidStack getOutput(IMeltingInventory inv) {
        FluidStack output = this.getOutput();
        ItemStack input = inv.getStack();
        int maxDamage = input.func_77958_k();
        if (maxDamage <= 0) {
            return output.copy();
        }
        return DamageableMeltingRecipe.scaleOutput(output, input.func_77952_i(), maxDamage);
    }

    @Override
    public void handleByproducts(IMeltingInventory inv, IFluidHandler handler) {
        ItemStack input = inv.getStack();
        int maxDamage = input.func_77958_k();
        if (maxDamage <= 0) {
            super.handleByproducts(inv, handler);
        } else {
            int itemDamage = input.func_77952_i();
            for (FluidStack fluidStack : this.byproducts) {
                handler.fill(DamageableMeltingRecipe.scaleOutput(fluidStack, itemDamage, maxDamage), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.damagableMeltingSerializer.get();
    }
}

