/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.JsonUtils;

public abstract class AbstractModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    protected static final String KEY_MAX_LEVEL = TConstruct.makeTranslationKey("recipe", "modifier.max_level");
    protected static final String KEY_NOT_ENOUGH_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slots");
    protected static final String KEY_NOT_ENOUGH_SLOT = TConstruct.makeTranslationKey("recipe", "modifier.not_enough_slot");
    protected static final ValidatedResult REQUIREMENTS_ERROR = ModifierRecipeLookup.DEFAULT_ERROR;
    private final ResourceLocation id;
    protected final Ingredient toolRequirement;
    protected final ModifierMatch requirements;
    protected final String requirementsError;
    protected final ModifierEntry result;
    private final int maxLevel;
    @Nullable
    private final SlotType.SlotCount slots;
    @Nullable
    private List<ItemStack> toolInputs = null;
    private List<ItemStack> displayInputs = null;
    private List<ItemStack> toolWithModifier = null;
    private ModifierEntry displayResult;

    @Deprecated
    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, int upgradeSlots, int abilitySlots) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.requirements = requirements;
        this.requirementsError = requirementsError;
        this.result = result;
        this.maxLevel = maxLevel;
        this.slots = abilitySlots > 0 ? new SlotType.SlotCount(SlotType.ABILITY, upgradeSlots) : (upgradeSlots > 0 ? new SlotType.SlotCount(SlotType.UPGRADE, upgradeSlots) : null);
        ModifierRecipeLookup.addRequirements(toolRequirement, result, requirements, requirementsError);
    }

    protected AbstractModifierRecipe(ResourceLocation id, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
        this.id = id;
        this.toolRequirement = toolRequirement;
        this.requirements = requirements;
        this.requirementsError = requirementsError;
        this.result = result;
        this.maxLevel = maxLevel;
        this.slots = slots;
        ModifierRecipeLookup.addRequirements(toolRequirement, result, requirements, requirementsError);
    }

    @Override
    public abstract ValidatedResult getValidatedResult(ITinkerStationInventory var1);

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getToolInputs() {
        if (this.toolInputs == null) {
            this.toolInputs = Arrays.stream(this.toolRequirement.func_193365_a()).map(stack -> {
                if (stack.func_77973_b() instanceof IModifiableDisplay) {
                    return ((IModifiableDisplay)stack.func_77973_b()).getRenderTool();
                }
                return stack;
            }).collect(Collectors.toList());
        }
        return this.toolInputs;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        if (this.displayResult == null) {
            int min = this.requirements.getMinLevel(this.result.getModifier());
            this.displayResult = min > 0 ? new ModifierEntry(this.result.getModifier(), this.result.getLevel() + min) : this.result;
        }
        return this.displayResult;
    }

    protected abstract void addIngredients(Consumer<List<ItemStack>> var1);

    @Override
    public List<List<ItemStack>> getDisplayItems() {
        if (this.displayInputs == null) {
            this.displayInputs = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, null)).collect(Collectors.toList());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(this.displayInputs);
        this.addIngredients(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            this.toolWithModifier = this.getToolInputs().stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, this.requirements, this.result)).collect(Collectors.toList());
        }
        return this.toolWithModifier;
    }

    @Override
    public boolean hasRequirements() {
        return this.requirements != ModifierMatch.ALWAYS;
    }

    @Override
    public String getRequirementsError() {
        if (this.requirementsError.isEmpty()) {
            return ModifierRecipeLookup.DEFAULT_ERROR_KEY;
        }
        return this.requirementsError;
    }

    public static List<ModifierEntry> getModifiersIgnoringPartial(ToolStack toolStack) {
        ImmutableList.Builder finalList = ImmutableList.builder();
        ModDataNBT persistentData = toolStack.getPersistentData();
        for (ModifierEntry entry : toolStack.getModifierList()) {
            Modifier modifier = entry.getModifier();
            int needed = ModifierRecipeLookup.getNeededPerLevel(modifier);
            if (needed == 0 || !persistentData.contains(modifier.getId(), 99)) {
                finalList.add((Object)entry);
                continue;
            }
            int has = persistentData.getInt(modifier.getId());
            if (has >= needed) {
                finalList.add((Object)entry);
                continue;
            }
            if (entry.getLevel() <= 1) continue;
            finalList.add((Object)new ModifierEntry(modifier, entry.getLevel() - 1));
        }
        return finalList.build();
    }

    protected ValidatedResult validatePrerequisites(ToolStack tool) {
        if (this.requirements != ModifierMatch.ALWAYS && !this.requirements.test(AbstractModifierRecipe.getModifiersIgnoringPartial(tool))) {
            return this.requirementsError.isEmpty() ? REQUIREMENTS_ERROR : ValidatedResult.failure(this.requirementsError, new Object[0]);
        }
        if (this.maxLevel != 0 && tool.getUpgrades().getLevel(this.result.getModifier()) + this.result.getLevel() > this.maxLevel) {
            return ValidatedResult.failure(KEY_MAX_LEVEL, this.result.getModifier().getDisplayName(), this.maxLevel);
        }
        if (this.slots != null) {
            int count = this.slots.getCount();
            if (tool.getFreeSlots(this.slots.getType()) < count) {
                if (count == 1) {
                    return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOT, this.slots.getType().getDisplayName());
                }
                return ValidatedResult.failure(KEY_NOT_ENOUGH_SLOTS, count, this.slots.getType().getDisplayName());
            }
        }
        return ValidatedResult.PASS;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    @Nullable
    public SlotType.SlotCount getSlots() {
        return this.slots;
    }

    public static abstract class Serializer<T extends AbstractModifierRecipe>
    extends LoggingRecipeSerializer<T> {
        public T read(ResourceLocation id, JsonObject json, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int upgradeSlots = SlotType.SlotCount.get(slots, SlotType.UPGRADE);
            int abilitySlots = SlotType.SlotCount.get(slots, SlotType.ABILITY);
            return this.read(id, json, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        }

        public T read(ResourceLocation id, PacketBuffer buffer, Ingredient toolRequirement, ModifierMatch requirements, String requirementsError, ModifierEntry result, int maxLevel, @Nullable SlotType.SlotCount slots) {
            int upgradeSlots = SlotType.SlotCount.get(slots, SlotType.UPGRADE);
            int abilitySlots = SlotType.SlotCount.get(slots, SlotType.ABILITY);
            return this.read(id, buffer, toolRequirement, requirements, requirementsError, result, maxLevel, upgradeSlots, abilitySlots);
        }

        @Deprecated
        public abstract T read(ResourceLocation var1, JsonObject var2, Ingredient var3, ModifierMatch var4, String var5, ModifierEntry var6, int var7, int var8, int var9);

        @Deprecated
        public abstract T read(ResourceLocation var1, PacketBuffer var2, Ingredient var3, ModifierMatch var4, String var5, ModifierEntry var6, int var7, int var8, int var9);

        public final T read(ResourceLocation id, JsonObject json) {
            Ingredient toolRequirement = Ingredient.func_199802_a((JsonElement)json.get("tools"));
            ModifierMatch requirements = ModifierMatch.ALWAYS;
            String requirementsError = "";
            if (json.has("requirements")) {
                JsonObject reqJson = JSONUtils.func_152754_s((JsonObject)json, (String)"requirements");
                requirements = ModifierMatch.deserialize(reqJson);
                requirementsError = JSONUtils.func_151219_a((JsonObject)reqJson, (String)"error", (String)"");
            }
            ModifierEntry result = ModifierEntry.fromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)0);
            if (maxLevel < 0) {
                throw new JsonSyntaxException("max must be non-negative");
            }
            SlotType.SlotCount slots = null;
            if (json.has("slots")) {
                slots = SlotType.SlotCount.fromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"slots"));
            } else {
                if (json.has("upgrade_slots") && json.has("ability_slots")) {
                    throw new JsonSyntaxException("Cannot set both upgrade_slots and ability_slots");
                }
                if (json.has("upgrade_slots")) {
                    slots = new SlotType.SlotCount(SlotType.UPGRADE, JsonUtils.getIntMin(json, "upgrade_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key upgrade_slots for recipe " + id);
                } else if (json.has("ability_slots")) {
                    slots = new SlotType.SlotCount(SlotType.ABILITY, JsonUtils.getIntMin(json, "ability_slots", 0));
                    TConstruct.LOG.warn("Using deprecated modifier recipe key ability_slots for recipe " + id);
                }
            }
            return this.read(id, json, toolRequirement, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        protected final T readSafe(ResourceLocation id, PacketBuffer buffer) {
            Ingredient toolRequirement = Ingredient.func_199566_b((PacketBuffer)buffer);
            ModifierMatch requirements = ModifierMatch.read(buffer);
            String requirementsError = buffer.func_150789_c(Short.MAX_VALUE);
            ModifierEntry result = ModifierEntry.read(buffer);
            int maxLevel = buffer.func_150792_a();
            SlotType.SlotCount slots = SlotType.SlotCount.read(buffer);
            return this.read(id, buffer, toolRequirement, requirements, requirementsError, result, maxLevel, slots);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, T recipe) {
            ((AbstractModifierRecipe)recipe).toolRequirement.func_199564_a(buffer);
            ((AbstractModifierRecipe)recipe).requirements.write(buffer);
            buffer.func_180714_a(((AbstractModifierRecipe)recipe).requirementsError);
            ((AbstractModifierRecipe)recipe).result.write(buffer);
            buffer.func_150787_b(((AbstractModifierRecipe)recipe).getMaxLevel());
            SlotType.SlotCount.write(((AbstractModifierRecipe)recipe).getSlots(), buffer);
        }
    }
}

