/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.mojang.datafixers.util.Pair;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.SpecializedRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.CraftingTableRepairKitRecipe;

public class SpecializedRepairKitRecipe
extends CraftingTableRepairKitRecipe
implements SpecializedRepairRecipeSerializer.ISpecializedRepairRecipe {
    private final Ingredient tool;
    private final MaterialId repairMaterialID;
    private IMaterial repairMaterial;

    public SpecializedRepairKitRecipe(ResourceLocation id, Ingredient tool, MaterialId repairMaterialID) {
        super(id);
        this.tool = tool;
        this.repairMaterialID = repairMaterialID;
    }

    private IMaterial getRepairMaterial() {
        if (this.repairMaterial == null) {
            this.repairMaterial = MaterialRegistry.getMaterial(this.repairMaterialID);
        }
        return this.repairMaterial;
    }

    @Override
    protected boolean toolMatches(ItemStack stack) {
        return this.tool.test(stack);
    }

    @Override
    protected float getRepairAmount(IModifierToolStack tool, IMaterial repairMaterial) {
        return (tool.getDefinition().getBaseStatDefinition().getBonus(ToolStats.DURABILITY) + 1.0f) * 2.0f / 3.0f;
    }

    @Override
    public boolean matches(CraftingInventory inv, World worldIn) {
        Pair<ToolStack, IMaterial> inputs = this.getRelevantInputs(inv);
        return inputs != null && inputs.getSecond() == this.getRepairMaterial();
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.specializedRepairKitSerializer.get();
    }

    @Override
    public Ingredient getTool() {
        return this.tool;
    }

    @Override
    public MaterialId getRepairMaterialID() {
        return this.repairMaterialID;
    }
}

