/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraftforge.common.util.Lazy;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.MeleeHarvestToolStatsBuilder;

public class ToolDefinition {
    public static final ToolDefinition EMPTY = new ToolDefinition(new ToolBaseStatDefinition.Builder().build(), Collections::emptyList, Collections::emptyList);
    public static final BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> NO_PARTS_STATS_BUILDER = (definition, materials) -> ToolStatsBuilder.noParts(definition);
    public static final BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> MELEE_HARVEST_STATS_BUILDER = MeleeHarvestToolStatsBuilder::from;
    private final ToolBaseStatDefinition baseStatDefinition;
    protected final Lazy<List<IToolPart>> requiredComponents;
    protected final Lazy<List<ModifierEntry>> modifiers;
    protected final BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> statsBuilder;
    private int[] repairIndices;

    public ToolDefinition(ToolBaseStatDefinition baseStatDefinition, Supplier<List<IToolPart>> requiredComponents, Supplier<List<ModifierEntry>> modifiers, BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> statsBuilder) {
        this.baseStatDefinition = baseStatDefinition;
        this.requiredComponents = Lazy.of(requiredComponents);
        this.modifiers = Lazy.of(modifiers);
        this.statsBuilder = statsBuilder;
    }

    public ToolDefinition(ToolBaseStatDefinition baseStatDefinition, Supplier<List<IToolPart>> requiredComponents, Supplier<List<ModifierEntry>> modifiers) {
        this(baseStatDefinition, requiredComponents, modifiers, MELEE_HARVEST_STATS_BUILDER);
    }

    public static Builder builder(ToolBaseStatDefinition baseStats) {
        return new Builder(baseStats);
    }

    public ToolBaseStatDefinition getBaseStatDefinition() {
        return this.baseStatDefinition;
    }

    public List<IToolPart> getRequiredComponents() {
        return (List)this.requiredComponents.get();
    }

    public boolean isMultipart() {
        return !this.getRequiredComponents().isEmpty();
    }

    public StatsNBT buildStats(List<IMaterial> materials) {
        return this.statsBuilder.apply(this, materials).buildStats();
    }

    public List<ModifierEntry> getModifiers() {
        return (List)this.modifiers.get();
    }

    public int[] getRepairParts() {
        if (this.repairIndices == null) {
            List components = (List)this.requiredComponents.get();
            if (components.isEmpty()) {
                this.repairIndices = new int[0];
            } else {
                IMaterialRegistry registry = MaterialRegistry.getInstance();
                this.repairIndices = IntStream.range(0, components.size()).filter(i -> registry.getDefaultStats(((IToolPart)components.get(i)).getStatType()) instanceof IRepairableMaterialStats).toArray();
            }
        }
        return this.repairIndices;
    }

    public static class Builder {
        private final ToolBaseStatDefinition baseStatDefinition;
        private final ImmutableList.Builder<Supplier<? extends IToolPart>> parts = ImmutableList.builder();
        private final ImmutableList.Builder<Supplier<? extends ModifierEntry>> modifiers = ImmutableList.builder();
        private BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> statsBuilder;

        public Builder addPart(Supplier<? extends IToolPart> part) {
            this.parts.add(part);
            return this;
        }

        public Builder addModifier(Supplier<? extends Modifier> modifier, int level) {
            this.modifiers.add(() -> new ModifierEntry((Modifier)modifier.get(), level));
            return this;
        }

        public Builder addModifier(Supplier<? extends Modifier> modifier) {
            return this.addModifier(modifier, 1);
        }

        public ToolDefinition build() {
            ImmutableList parts = this.parts.build();
            BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> statsBuilder = this.statsBuilder;
            if (statsBuilder == null) {
                statsBuilder = parts.isEmpty() ? NO_PARTS_STATS_BUILDER : MELEE_HARVEST_STATS_BUILDER;
            }
            ImmutableList modifiers = this.modifiers.build();
            return new ToolDefinition(this.baseStatDefinition, Builder.supplierListToSupplier(parts), Builder.supplierListToSupplier(modifiers), statsBuilder);
        }

        private static <T> Supplier<List<T>> supplierListToSupplier(List<Supplier<? extends T>> list) {
            if (list.isEmpty()) {
                return Collections::emptyList;
            }
            return () -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Supplier supplier : list) {
                    builder.add(supplier.get());
                }
                return builder.build();
            };
        }

        private Builder(ToolBaseStatDefinition baseStatDefinition) {
            this.baseStatDefinition = baseStatDefinition;
        }

        public Builder setStatsBuilder(BiFunction<ToolDefinition, List<IMaterial>, ? extends ToolStatsBuilder> statsBuilder) {
            this.statsBuilder = statsBuilder;
            return this;
        }
    }
}

