/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;

public class ToolAttackContext {
    @Nonnull
    private final LivingEntity attacker;
    @Nullable
    private final PlayerEntity playerAttacker;
    @Nonnull
    private final Hand hand;
    @Nonnull
    private final Entity target;
    @Nullable
    private final LivingEntity livingTarget;
    private final boolean isCritical;
    private final float cooldown;
    private final boolean isExtraAttack;

    public boolean isFullyCharged() {
        return this.getCooldown() > 0.9f;
    }

    public ToolAttackContext(@Nonnull LivingEntity attacker, @Nullable PlayerEntity playerAttacker, @Nonnull Hand hand, @Nonnull Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attacker = attacker;
        this.playerAttacker = playerAttacker;
        this.hand = hand;
        this.target = target;
        this.livingTarget = livingTarget;
        this.isCritical = isCritical;
        this.cooldown = cooldown;
        this.isExtraAttack = isExtraAttack;
    }

    @Nonnull
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public PlayerEntity getPlayerAttacker() {
        return this.playerAttacker;
    }

    @Nonnull
    public Hand getHand() {
        return this.hand;
    }

    @Nonnull
    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getLivingTarget() {
        return this.livingTarget;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public boolean isExtraAttack() {
        return this.isExtraAttack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolAttackContext)) {
            return false;
        }
        ToolAttackContext other = (ToolAttackContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LivingEntity this$attacker = this.getAttacker();
        LivingEntity other$attacker = other.getAttacker();
        if (this$attacker == null ? other$attacker != null : !this$attacker.equals(other$attacker)) {
            return false;
        }
        PlayerEntity this$playerAttacker = this.getPlayerAttacker();
        PlayerEntity other$playerAttacker = other.getPlayerAttacker();
        if (this$playerAttacker == null ? other$playerAttacker != null : !this$playerAttacker.equals(other$playerAttacker)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        if (this$hand == null ? other$hand != null : !this$hand.equals(other$hand)) {
            return false;
        }
        Entity this$target = this.getTarget();
        Entity other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        LivingEntity this$livingTarget = this.getLivingTarget();
        LivingEntity other$livingTarget = other.getLivingTarget();
        if (this$livingTarget == null ? other$livingTarget != null : !this$livingTarget.equals(other$livingTarget)) {
            return false;
        }
        if (this.isCritical() != other.isCritical()) {
            return false;
        }
        if (Float.compare(this.getCooldown(), other.getCooldown()) != 0) {
            return false;
        }
        return this.isExtraAttack() == other.isExtraAttack();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ToolAttackContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LivingEntity $attacker = this.getAttacker();
        result = result * 59 + ($attacker == null ? 43 : $attacker.hashCode());
        PlayerEntity $playerAttacker = this.getPlayerAttacker();
        result = result * 59 + ($playerAttacker == null ? 43 : $playerAttacker.hashCode());
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : $hand.hashCode());
        Entity $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        LivingEntity $livingTarget = this.getLivingTarget();
        result = result * 59 + ($livingTarget == null ? 43 : $livingTarget.hashCode());
        result = result * 59 + (this.isCritical() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getCooldown());
        result = result * 59 + (this.isExtraAttack() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ToolAttackContext(attacker=" + this.getAttacker() + ", playerAttacker=" + this.getPlayerAttacker() + ", hand=" + this.getHand() + ", target=" + this.getTarget() + ", livingTarget=" + this.getLivingTarget() + ", isCritical=" + this.isCritical() + ", cooldown=" + this.getCooldown() + ", isExtraAttack=" + this.isExtraAttack() + ")";
    }
}

