/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class TooltipBuilder {
    private static final net.minecraft.util.text.Color MAX = TooltipBuilder.valueToColor(1.0f, 1.0f);
    private static final UnaryOperator<Style> APPLY_MAX = style -> style.func_240718_a_(MAX);
    private static final ITextComponent TOOLTIP_BROKEN = TConstruct.makeTranslation("tooltip", "tool.broken").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.DARK_RED});
    private static final ITextComponent TOOLTIP_BROKEN_PREFIXED = ToolStats.DURABILITY.getPrefix().func_230529_a_(TOOLTIP_BROKEN);
    private final IModifierToolStack tool;
    private final List<ITextComponent> tooltips;

    public TooltipBuilder(ToolStack tool) {
        this.tool = tool;
        this.tooltips = new ArrayList<ITextComponent>();
    }

    public TooltipBuilder add(ITextComponent textComponent) {
        this.tooltips.add(textComponent);
        return this;
    }

    public TooltipBuilder add(IToolStat<?> stat) {
        this.tooltips.add(stat.formatValue(this.tool.getStats().getFloat(stat)));
        return this;
    }

    public static ITextComponent formatDurability(int durability, int ref, boolean textIfBroken) {
        if (textIfBroken && durability == 0) {
            return TOOLTIP_BROKEN_PREFIXED;
        }
        return ToolStats.DURABILITY.getPrefix().func_230529_a_(TooltipBuilder.formatPartialAmount(durability, ref));
    }

    public static net.minecraft.util.text.Color valueToColor(float value, float max) {
        float hue = MathHelper.func_76131_a((float)(value / max / 3.0f), (float)0.01f, (float)0.5f);
        return net.minecraft.util.text.Color.func_240743_a_((int)Color.HSBtoRGB(hue, 0.65f, 0.8f));
    }

    public static ITextComponent formatPartialAmount(int value, int max) {
        return new StringTextComponent(Util.COMMA_FORMAT.format(value)).func_240700_a_(style -> style.func_240718_a_(TooltipBuilder.valueToColor(value, max))).func_230529_a_((ITextComponent)new StringTextComponent(" / ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(Util.COMMA_FORMAT.format(max)).func_240700_a_(APPLY_MAX));
    }

    public TooltipBuilder addDurability() {
        this.tooltips.add(TooltipBuilder.formatDurability(this.tool.getCurrentDurability(), this.tool.getStats().getInt(ToolStats.DURABILITY), false));
        return this;
    }

    public TooltipBuilder addWithAttribute(IToolStat<?> stat, Attribute attribute) {
        ModifiableAttributeInstance instance;
        float damage = (float)attribute.func_111110_b();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (instance = player.func_110148_a(attribute)) != null) {
            damage = (float)instance.func_111125_b();
        }
        this.tooltips.add(ToolStats.ATTACK_DAMAGE.formatValue(damage + this.tool.getStats().getFloat(stat)));
        return this;
    }

    public TooltipBuilder addFreeSlots(SlotType slotType) {
        int slots = this.tool.getFreeSlots(slotType);
        if (slots > 0) {
            this.tooltips.add(IToolStat.formatNumber(slotType.getPrefix(), slotType.getColor(), slots));
        }
        return this;
    }

    public TooltipBuilder addAllFreeSlots() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            this.addFreeSlots(slotType);
        }
        return this;
    }

    public TooltipBuilder addModifierInfo(boolean advanced) {
        for (ModifierEntry entry : this.tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(advanced)) continue;
            this.tooltips.add(entry.getModifier().getDisplayName(this.tool, entry.getLevel()));
        }
        return this;
    }

    @Deprecated
    public TooltipBuilder addFreeUpgrades() {
        return this.addFreeSlots(SlotType.UPGRADE);
    }

    @Deprecated
    public TooltipBuilder addFreeAbilities() {
        return this.addFreeSlots(SlotType.ABILITY);
    }

    public TooltipBuilder(IModifierToolStack tool, List<ITextComponent> tooltips) {
        this.tool = tool;
        this.tooltips = tooltips;
    }

    public List<ITextComponent> getTooltips() {
        return this.tooltips;
    }
}

