/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.List;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class TooltipUtil {
    public static final String KEY_DISPLAY = "tic_display";
    public static final ITextComponent TOOLTIP_HOLD_SHIFT = TConstruct.makeTranslation("tooltip", "hold_shift", TConstruct.makeTranslation("key", "shift").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.ITALIC}));
    public static final ITextComponent TOOLTIP_HOLD_CTRL = TConstruct.makeTranslation("tooltip", "hold_ctrl", TConstruct.makeTranslation("key", "ctrl").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.ITALIC}));
    private static final ITextComponent NO_DATA = TConstruct.makeTranslation("tooltip", "missing_data").func_240699_a_(TextFormatting.GRAY);

    private TooltipUtil() {
    }

    public static boolean isDisplay(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(KEY_DISPLAY);
    }

    public static void addInformation(IModifiableDisplay item, ItemStack stack, List<ITextComponent> tooltip, TooltipKey tooltipKey, boolean isAdvanced) {
        if (TooltipUtil.isDisplay(stack)) {
            ToolStack tool = ToolStack.from(stack);
            for (ModifierEntry entry : tool.getModifierList()) {
                if (!entry.getModifier().shouldDisplay(false)) continue;
                tooltip.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
            }
        } else if (!ToolStack.isInitialized(stack)) {
            if (item.getToolDefinition().isMultipart()) {
                tooltip.add(NO_DATA);
            }
        } else {
            switch (tooltipKey) {
                case SHIFT: {
                    item.getStatInformation(ToolStack.from(stack), tooltip, isAdvanced ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL);
                    break;
                }
                case CONTROL: {
                    if (item.getToolDefinition().isMultipart()) {
                        TooltipUtil.getComponents(item, stack, tooltip);
                        break;
                    }
                }
                default: {
                    TooltipUtil.getDefaultInfo(stack, tooltip);
                }
            }
        }
    }

    public static void getDefaultInfo(ItemStack stack, List<ITextComponent> tooltips) {
        ToolStack tool = ToolStack.from(stack);
        if (stack.func_77984_f()) {
            tooltips.add(TooltipBuilder.formatDurability(tool.getCurrentDurability(), tool.getStats().getInt(ToolStats.DURABILITY), true));
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(false)) continue;
            tooltips.add(entry.getModifier().getDisplayName(tool, entry.getLevel()));
        }
        tooltips.add(StringTextComponent.field_240750_d_);
        tooltips.add(TOOLTIP_HOLD_SHIFT);
        if (tool.getDefinition().isMultipart()) {
            tooltips.add(TOOLTIP_HOLD_CTRL);
        }
    }

    public static List<ITextComponent> getDefaultStats(IModifierToolStack tool, List<ITextComponent> tooltip, TooltipFlag flag) {
        TooltipBuilder builder = new TooltipBuilder(tool, tooltip);
        Item item = tool.getItem();
        if (TinkerTags.Items.DURABILITY.func_230235_a_((Object)item)) {
            builder.addDurability();
        }
        if (TinkerTags.Items.MELEE.func_230235_a_((Object)item)) {
            builder.addWithAttribute(ToolStats.ATTACK_DAMAGE, Attributes.field_233823_f_);
            builder.add(ToolStats.ATTACK_SPEED);
        }
        if (TinkerTags.Items.HARVEST.func_230235_a_((Object)item)) {
            if (TinkerTags.Items.HARVEST_PRIMARY.func_230235_a_((Object)tool.getItem())) {
                builder.add(ToolStats.HARVEST_LEVEL);
            }
            builder.add(ToolStats.MINING_SPEED);
        }
        builder.addAllFreeSlots();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getModifier().addInformation(tool, entry.getLevel(), tooltip, flag);
        }
        return builder.getTooltips();
    }

    public static void getComponents(IModifiable item, ItemStack stack, List<ITextComponent> tooltips) {
        List<IToolPart> components = item.getToolDefinition().getRequiredComponents();
        if (components.isEmpty()) {
            return;
        }
        List<IMaterial> materials = ToolStack.from(stack).getMaterialsList();
        if (materials.isEmpty()) {
            tooltips.add(NO_DATA);
            return;
        }
        if (materials.size() < components.size()) {
            return;
        }
        int max = components.size() - 1;
        for (int i = 0; i <= max; ++i) {
            IToolPart requirement = components.get(i);
            IMaterial material = materials.get(i);
            ItemStack partStack = requirement.withMaterial(material);
            tooltips.add((ITextComponent)partStack.func_200301_q().func_230532_e_().func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240718_a_(material.getColor())));
            MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), requirement.getStatType()).ifPresent(stat -> tooltips.addAll(stat.getLocalizedInfo()));
            if (i == max) continue;
            tooltips.add(StringTextComponent.field_240750_d_);
        }
    }
}

