/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper.aoe;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class RectangleAOEHarvestLogic
extends ToolHarvestLogic {
    public static final RectangleAOEHarvestLogic SMALL = new RectangleAOEHarvestLogic(0, 0, 0);
    public static final RectangleAOEHarvestLogic LARGE = new RectangleAOEHarvestLogic(1, 1, 0);
    protected final int extraWidth;
    protected final int extraHeight;
    protected final int extraDepth;

    @Override
    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return RectangleAOEHarvestLogic.calculate(this, tool, stack, world, player, origin, sideHit, this.extraWidth + (expanded + 1) / 2, this.extraHeight + expanded / 2, this.extraDepth, matchType);
    }

    public static Iterable<BlockPos> calculate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, World world, PlayerEntity player, BlockPos origin, Direction sideHit, int extraWidth, int extraHeight, int extraDepth, ToolHarvestLogic.AOEMatchType matchType) {
        Direction widthDir;
        Direction heightDir;
        if (extraDepth == 0 && extraWidth == 0 && extraHeight == 0) {
            return Collections.emptyList();
        }
        Direction depthDir = sideHit.func_176734_d();
        if (sideHit.func_176740_k() == Direction.Axis.Y) {
            heightDir = player.func_174811_aO();
            widthDir = heightDir.func_176746_e();
        } else {
            widthDir = sideHit.func_176735_f();
            heightDir = Direction.UP;
        }
        Predicate<BlockPos> posPredicate = RectangleAOEHarvestLogic.getDefaultBlockPredicate(self, tool, stack, world, origin, matchType);
        return () -> new RectangleIterator(origin, widthDir, extraWidth, heightDir, extraHeight, depthDir, extraDepth, posPredicate);
    }

    public RectangleAOEHarvestLogic(int extraWidth, int extraHeight, int extraDepth) {
        this.extraWidth = extraWidth;
        this.extraHeight = extraHeight;
        this.extraDepth = extraDepth;
    }

    public static class RectangleIterator
    extends AbstractIterator<BlockPos> {
        private final Direction widthDir;
        private final Direction heightDir;
        private final Direction depthDir;
        private final int maxWidth;
        private final int maxHeight;
        private final int maxDepth;
        private int currentWidth = 0;
        private int currentHeight = 0;
        private int currentDepth = 0;
        protected final BlockPos origin;
        protected final BlockPos.Mutable mutablePos;
        protected final Predicate<BlockPos> posPredicate;
        protected int lastX;
        protected int lastY;
        protected int lastZ;

        public RectangleIterator(BlockPos origin, Direction widthDir, int extraWidth, Direction heightDir, int extraHeight, Direction depthDir, int extraDepth, Predicate<BlockPos> posPredicate) {
            this(origin, widthDir, extraWidth, heightDir, extraHeight, true, depthDir, extraDepth, posPredicate);
        }

        public RectangleIterator(BlockPos origin, Direction widthDir, int extraWidth, Direction heightDir, int extraHeight, boolean traverseDown, Direction depthDir, int extraDepth, Predicate<BlockPos> posPredicate) {
            this.origin = origin;
            this.widthDir = widthDir;
            this.heightDir = heightDir;
            this.depthDir = depthDir;
            this.maxWidth = extraWidth * 2;
            this.maxHeight = traverseDown ? extraHeight * 2 : extraHeight;
            this.maxDepth = extraDepth;
            this.mutablePos = new BlockPos.Mutable(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
            this.posPredicate = posPredicate;
            if (extraWidth > 0) {
                --this.currentWidth;
            } else if (extraHeight > 0) {
                --this.currentHeight;
            }
            this.mutablePos.func_189534_c(widthDir, -extraWidth + this.currentWidth);
            if (traverseDown) {
                this.mutablePos.func_189534_c(heightDir, -extraHeight + this.currentHeight);
            } else if (this.currentHeight != 0) {
                this.mutablePos.func_189534_c(heightDir, this.currentHeight);
            }
            this.lastX = this.mutablePos.func_177958_n();
            this.lastY = this.mutablePos.func_177956_o();
            this.lastZ = this.mutablePos.func_177952_p();
        }

        protected boolean incrementPosition() {
            if (this.currentWidth == this.maxWidth) {
                if (this.currentHeight == this.maxHeight) {
                    if (this.currentDepth == this.maxDepth) {
                        return false;
                    }
                    ++this.currentDepth;
                    this.mutablePos.func_189536_c(this.depthDir);
                    this.currentHeight = 0;
                    this.mutablePos.func_189534_c(this.heightDir, -this.maxHeight);
                } else {
                    ++this.currentHeight;
                    this.mutablePos.func_189536_c(this.heightDir);
                }
                this.currentWidth = 0;
                this.mutablePos.func_189534_c(this.widthDir, -this.maxWidth);
            } else {
                ++this.currentWidth;
                this.mutablePos.func_189536_c(this.widthDir);
            }
            return true;
        }

        protected BlockPos computeNext() {
            this.mutablePos.func_181079_c(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || !this.posPredicate.test((BlockPos)this.mutablePos)) continue;
                this.lastX = this.mutablePos.func_177958_n();
                this.lastY = this.mutablePos.func_177956_o();
                this.lastZ = this.mutablePos.func_177952_p();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

