/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class ToolStack
implements IModifierToolStack {
    private static final String KEY_VALIDATE_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.validate_slots");
    @Deprecated
    public static final ResourceLocation ORIGINAL_DURABILITY_KEY = TConstruct.getResource("durability");
    protected static final String TAG_MATERIALS = "tic_materials";
    protected static final String TAG_STATS = "tic_stats";
    protected static final String TAG_MULTIPLIERS = "tic_multipliers";
    public static final String TAG_PERSISTENT_MOD_DATA = "tic_persistent_data";
    public static final String TAG_VOLATILE_MOD_DATA = "tic_volatile_data";
    public static final String TAG_UPGRADES = "tic_upgrades";
    public static final String TAG_MODIFIERS = "tic_modifiers";
    public static final String TAG_BROKEN = "tic_broken";
    protected static final String TAG_DAMAGE = "Damage";
    public static final String TAG_UNBREAKABLE = "Unbreakable";
    private static final Set<String> RESTRICTED_TAGS = ImmutableSet.of((Object)"tic_materials", (Object)"tic_stats", (Object)"tic_multipliers", (Object)"tic_persistent_data", (Object)"tic_volatile_data", (Object)"tic_upgrades", (Object[])new String[]{"tic_modifiers", "tic_broken", "Damage", "Enchantments", "HideFlags"});
    private final Item item;
    private final ToolDefinition definition;
    private final CompoundNBT nbt;
    private RestrictedCompoundTag restrictedNBT;
    private int damage = -1;
    @Nullable
    private Boolean broken;
    @Nullable
    private MaterialNBT materials;
    @Nullable
    private ModifierNBT upgrades;
    @Nullable
    private ModDataNBT persistentModData;
    @Nullable
    private ModifierNBT modifiers;
    @Nullable
    private StatsNBT stats;
    @Nullable
    private StatsNBT multipliers;
    @Nullable
    private IModDataReadOnly volatileModData;

    private static ToolStack from(ItemStack stack, boolean copyNbt) {
        Item item = stack.func_77973_b();
        ToolDefinition definition = item instanceof IModifiable ? ((IModifiable)item).getToolDefinition() : ToolDefinition.EMPTY;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
            if (!copyNbt) {
                stack.func_77982_d(nbt);
            }
        } else if (copyNbt) {
            nbt = nbt.func_74737_b();
        }
        return ToolStack.from(item, definition, nbt);
    }

    public static ToolStack from(ItemStack stack) {
        return ToolStack.from(stack, false);
    }

    public static ToolStack copyFrom(ItemStack stack) {
        return ToolStack.from(stack, true);
    }

    public static ToolStack createTool(Item item, ToolDefinition definition, List<IMaterial> materials) {
        ToolStack tool = ToolStack.from(item, definition, new CompoundNBT());
        tool.damage = 0;
        tool.broken = false;
        tool.upgrades = ModifierNBT.EMPTY;
        definition.getBaseStatDefinition().buildSlots(tool.getPersistentData());
        tool.setMaterials(materials);
        return tool;
    }

    public ToolStack copy() {
        ToolStack tool = ToolStack.from(this.item, this.definition, this.nbt.func_74737_b());
        tool.damage = this.damage;
        tool.broken = this.broken;
        tool.materials = this.materials;
        tool.upgrades = this.upgrades;
        tool.modifiers = this.modifiers;
        tool.stats = this.stats;
        return tool;
    }

    public void clearCache() {
        this.damage = -1;
        this.broken = null;
        this.materials = null;
        this.upgrades = null;
        this.modifiers = null;
        this.stats = null;
        this.multipliers = null;
        this.volatileModData = null;
        this.persistentModData = null;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((IItemProvider)this.item, 1);
        stack.func_77982_d(this.nbt);
        return stack;
    }

    public ItemStack updateStack(ItemStack stack) {
        if (stack.func_77973_b() != this.item) {
            throw new IllegalArgumentException("Wrong item in stack");
        }
        stack.func_77982_d(this.nbt.func_74737_b());
        return stack;
    }

    public RestrictedCompoundTag getRestrictedNBT() {
        if (this.restrictedNBT == null) {
            this.restrictedNBT = new RestrictedCompoundTag(this.nbt, RESTRICTED_TAGS);
        }
        return this.restrictedNBT;
    }

    @Override
    public boolean isBroken() {
        if (this.broken == null) {
            this.broken = this.nbt.func_74767_n(TAG_BROKEN);
        }
        return this.broken;
    }

    @Override
    public boolean isUnbreakable() {
        return this.nbt.func_74767_n(TAG_UNBREAKABLE);
    }

    protected void setBrokenRaw(boolean broken) {
        this.broken = broken;
        this.nbt.func_74757_a(TAG_BROKEN, broken);
    }

    protected void breakTool() {
        this.setDamage(this.getStats().getInt(ToolStats.DURABILITY));
    }

    protected int getDamageRaw() {
        if (this.damage == -1) {
            this.damage = this.nbt.func_74762_e(TAG_DAMAGE);
        }
        return this.damage;
    }

    @Override
    public int getDamage() {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.isBroken()) {
            return durability;
        }
        return Math.min(this.getDamageRaw(), durability - 1);
    }

    @Override
    public int getCurrentDurability() {
        if (this.isBroken()) {
            return 0;
        }
        return Math.max(0, this.getStats().getInt(ToolStats.DURABILITY) - this.getDamageRaw());
    }

    @Override
    public void setDamage(int damage) {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (damage >= durability) {
            damage = Math.max(0, durability);
            this.setBrokenRaw(true);
        } else {
            this.setBrokenRaw(false);
        }
        this.damage = damage;
        this.nbt.func_74768_a(TAG_DAMAGE, damage);
    }

    @Override
    public StatsNBT getStats() {
        if (this.stats == null) {
            this.stats = StatsNBT.readFromNBT(this.nbt.func_74781_a(TAG_STATS));
        }
        return this.stats;
    }

    protected void setStats(StatsNBT stats) {
        this.stats = stats;
        this.nbt.func_218657_a(TAG_STATS, (INBT)stats.serializeToNBT());
        int newMax = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.getDamageRaw() >= newMax) {
            this.setDamage(newMax);
        }
    }

    protected StatsNBT getMultipliers() {
        if (this.multipliers == null) {
            this.multipliers = StatsNBT.readFromNBT(this.nbt.func_74781_a(TAG_MULTIPLIERS));
        }
        return this.multipliers;
    }

    protected void setMultipliers(StatsNBT multipliers) {
        this.multipliers = multipliers;
        this.nbt.func_218657_a(TAG_MULTIPLIERS, (INBT)multipliers.serializeToNBT());
    }

    @Override
    public float getModifier(FloatToolStat stat) {
        StatsNBT multipliers = this.getMultipliers();
        if (multipliers.hasStat(stat)) {
            return multipliers.getFloat(stat);
        }
        return 1.0f;
    }

    @Override
    public MaterialNBT getMaterials() {
        if (!this.getDefinition().isMultipart()) {
            return MaterialNBT.EMPTY;
        }
        if (this.materials == null) {
            this.materials = MaterialNBT.readFromNBT(this.nbt.func_74781_a(TAG_MATERIALS));
        }
        return this.materials;
    }

    protected void setMaterialsRaw(MaterialNBT materials) {
        this.materials = materials;
        if (materials == MaterialNBT.EMPTY) {
            this.nbt.func_82580_o(TAG_MATERIALS);
        } else {
            this.nbt.func_218657_a(TAG_MATERIALS, (INBT)materials.serializeToNBT());
        }
    }

    public void setMaterials(MaterialNBT materials) {
        this.setMaterialsRaw(materials);
        this.rebuildStats();
    }

    public void setMaterials(List<IMaterial> materials) {
        this.setMaterials(materials.isEmpty() ? MaterialNBT.EMPTY : new MaterialNBT(materials));
    }

    public void replaceMaterial(int index, IMaterial replacement) {
        this.setMaterials(this.getMaterials().replaceMaterial(index, replacement));
    }

    @Override
    public ModifierNBT getUpgrades() {
        if (this.upgrades == null) {
            this.upgrades = ModifierNBT.readFromNBT(this.nbt.func_74781_a(TAG_UPGRADES));
        }
        return this.upgrades;
    }

    public void addModifier(Modifier modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withModifier(modifier, level);
        this.nbt.func_218657_a(TAG_UPGRADES, (INBT)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    public void removeModifier(Modifier modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withoutModifier(modifier, level);
        this.nbt.func_218657_a(TAG_UPGRADES, (INBT)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    @Override
    public ModifierNBT getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = ModifierNBT.readFromNBT(this.nbt.func_74781_a(TAG_MODIFIERS));
        }
        return this.modifiers;
    }

    protected void setModifiers(ModifierNBT modifiers) {
        this.modifiers = modifiers;
        this.nbt.func_218657_a(TAG_MODIFIERS, (INBT)this.modifiers.serializeToNBT());
    }

    @Override
    public ModDataNBT getPersistentData() {
        if (this.persistentModData == null) {
            if (this.nbt.func_150297_b(TAG_PERSISTENT_MOD_DATA, 10)) {
                this.persistentModData = ModDataNBT.readFromNBT(this.nbt.func_74775_l(TAG_PERSISTENT_MOD_DATA));
            } else {
                CompoundNBT tag = new CompoundNBT();
                this.nbt.func_218657_a(TAG_PERSISTENT_MOD_DATA, (INBT)tag);
                this.persistentModData = ModDataNBT.readFromNBT(tag);
            }
        }
        return this.persistentModData;
    }

    @Override
    public IModDataReadOnly getVolatileData() {
        if (this.volatileModData == null) {
            this.volatileModData = this.nbt.func_150297_b(TAG_VOLATILE_MOD_DATA, 10) ? ModDataNBT.readFromNBT(this.nbt.func_74775_l(TAG_VOLATILE_MOD_DATA)) : IModDataReadOnly.EMPTY;
        }
        return this.volatileModData;
    }

    protected void setVolatileModData(ModDataNBT modData) {
        CompoundNBT data = modData.getData();
        if (data.isEmpty()) {
            this.volatileModData = IModDataReadOnly.EMPTY;
            this.nbt.func_82580_o(TAG_VOLATILE_MOD_DATA);
        } else {
            this.volatileModData = modData;
            this.nbt.func_218657_a(TAG_VOLATILE_MOD_DATA, (INBT)data);
        }
    }

    public ValidatedResult validate() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            if (this.getFreeSlots(slotType) >= 0) continue;
            return ValidatedResult.failure(KEY_VALIDATE_SLOTS, slotType.getDisplayName());
        }
        for (ModifierEntry entry : this.getModifierList()) {
            ValidatedResult result = entry.getModifier().validate(this, entry.getLevel());
            if (!result.hasError()) continue;
            return result;
        }
        return ValidatedResult.PASS;
    }

    public void rebuildStats() {
        ModifierNBT.Builder modBuilder = ModifierNBT.builder();
        modBuilder.add(this.getUpgrades());
        modBuilder.add(this.getDefinition().getModifiers());
        List<IToolPart> parts = this.getDefinition().getRequiredComponents();
        List<IMaterial> materials = this.getMaterialsList();
        int max = Math.min(materials.size(), parts.size());
        for (int i = 0; i < max; ++i) {
            modBuilder.add(MaterialRegistry.getInstance().getTraits(materials.get(i).getIdentifier(), parts.get(i).getStatType()));
        }
        ModifierNBT allMods = modBuilder.build();
        this.setModifiers(allMods);
        StatsNBT stats = this.definition.buildStats(materials);
        ModifierStatsBuilder statBuilder = ModifierStatsBuilder.builder();
        this.definition.getBaseStatDefinition().buildStats(statBuilder);
        List<ModifierEntry> modifierList = allMods.getModifiers();
        if (modifierList.isEmpty()) {
            this.nbt.func_82580_o(TAG_VOLATILE_MOD_DATA);
            this.volatileModData = IModDataReadOnly.EMPTY;
        } else {
            ModDataNBT volatileData = new ModDataNBT();
            ModDataNBT persistentData = this.getPersistentData();
            ToolDefinition toolDefinition = this.getDefinition();
            for (ModifierEntry entry : modifierList) {
                entry.getModifier().addVolatileData(this.item, toolDefinition, stats, persistentData, entry.getLevel(), volatileData);
            }
            for (ModifierEntry entry : modifierList) {
                Modifier mod = entry.getModifier();
                int level = entry.getLevel();
                mod.addToolStats(this.item, toolDefinition, stats, persistentData, volatileData, level, statBuilder);
            }
            this.setVolatileModData(volatileData);
        }
        this.setStats(statBuilder.build(stats));
        this.setMultipliers(statBuilder.buildMultipliers());
        for (ModifierEntry entry : modifierList) {
            entry.getModifier().addRawData(this, entry.getLevel(), this.getRestrictedNBT());
        }
    }

    public static boolean isInitialized(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b(TAG_STATS, 10);
    }

    public static boolean hasMaterials(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b(TAG_MATERIALS, 9);
    }

    public static void ensureInitialized(ItemStack stack, ToolDefinition toolDefinition) {
        if (!(ToolStack.isInitialized(stack) || toolDefinition.isMultipart() && !ToolStack.hasMaterials(stack))) {
            ToolStack tool = ToolStack.from(stack);
            toolDefinition.getBaseStatDefinition().buildSlots(tool.getPersistentData());
            tool.rebuildStats();
        }
    }

    private ToolStack(Item item, ToolDefinition definition, CompoundNBT nbt) {
        this.item = item;
        this.definition = definition;
        this.nbt = nbt;
    }

    public static ToolStack from(Item item, ToolDefinition definition, CompoundNBT nbt) {
        return new ToolStack(item, definition, nbt);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public ToolDefinition getDefinition() {
        return this.definition;
    }

    protected CompoundNBT getNbt() {
        return this.nbt;
    }
}

