/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ToolStatsBuilder {
    protected final ToolBaseStatDefinition baseStats;

    public static ToolStatsBuilder noParts(ToolDefinition definition) {
        return new ToolStatsBuilder(definition.getBaseStatDefinition());
    }

    protected void setStats(StatsNBT.Builder builder) {
    }

    protected boolean handles(IToolStat<?> stat) {
        return false;
    }

    public StatsNBT buildStats() {
        StatsNBT.Builder builder = StatsNBT.builder();
        for (FloatToolStat stat : this.baseStats.getAllBonuses()) {
            if (this.handles(stat)) continue;
            builder.set(stat, stat.getDefaultValue() + this.baseStats.getBonus(stat));
        }
        this.setStats(builder);
        return builder.build();
    }

    @Nullable
    public static <T extends IMaterialStats> T fetchStatsOrDefault(MaterialStatsId statsId, IMaterial material, IToolPart requiredComponent) {
        if (statsId.equals((Object)requiredComponent.getStatType())) {
            return (T)MaterialRegistry.getInstance().getMaterialStats(material.getIdentifier(), statsId).orElseGet(() -> MaterialRegistry.getInstance().getDefaultStats(statsId));
        }
        return null;
    }

    public static <T extends IMaterialStats> List<T> listOfCompatibleWith(MaterialStatsId statsId, List<IMaterial> materials, List<IToolPart> requiredComponents) {
        return Streams.zip(materials.stream(), requiredComponents.stream(), (material, partMaterialType) -> ToolStatsBuilder.fetchStatsOrDefault(statsId, material, partMaterialType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T extends IMaterialStats> double getAverageValue(List<T> stats, Function<T, ? extends Number> statGetter) {
        return ToolStatsBuilder.getAverageValue(stats, statGetter, 0.0);
    }

    public static <T extends IMaterialStats, N extends Number> double getAverageValue(List<T> stats, Function<T, N> statGetter, double missingValue) {
        return stats.stream().mapToDouble(value -> ((Number)statGetter.apply(value)).doubleValue()).average().orElse(missingValue);
    }

    protected ToolStatsBuilder(ToolBaseStatDefinition baseStats) {
        this.baseStats = baseStats;
    }
}

