/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import slimeknights.tconstruct.TConstruct;

public class Util {
    public static final Marker TCONSTRUCT = MarkerManager.getMarker((String)"TCONSTRUCT");
    public static final DecimalFormat COMMA_FORMAT = new DecimalFormat("#,###,###.##", DecimalFormatSymbols.getInstance(Locale.US));
    public static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#%");
    public static final DecimalFormat MULTIPLIER_FORMAT = new DecimalFormat("#.##x");
    public static final DecimalFormat PERCENT_BOOST_FORMAT = new DecimalFormat("#%");

    public static Logger getLogger(String type) {
        return LogManager.getLogger((String)("tconstruct-" + type));
    }

    public static Optional<String> getCurrentlyActiveExternalMod() {
        return Optional.ofNullable(ModLoadingContext.get().getActiveContainer().getModId()).filter(activeModId -> !"tconstruct".equals(activeModId));
    }

    public static boolean canTranslate(String key) {
        return !ForgeI18n.getPattern((String)key).equals(key);
    }

    public static String makeTranslationKey(String base, ResourceLocation name) {
        return net.minecraft.util.Util.func_200697_a((String)base, (ResourceLocation)name);
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static String toIndentedStringList(Collection<?> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining("\n\t", "\n\t", ""));
    }

    public static int sign(int value) {
        if (value == 0) {
            return 0;
        }
        return value > 0 ? 1 : -1;
    }

    public static Direction directionFromOffset(BlockPos pos, BlockPos neighbor) {
        BlockPos offset = neighbor.func_177973_b((Vector3i)pos);
        for (Direction direction : Direction.values()) {
            if (!direction.func_176730_m().equals((Object)offset)) continue;
            return direction;
        }
        TConstruct.LOG.error("No direction for position {} and neighbor {}", (Object)pos, (Object)neighbor);
        return Direction.DOWN;
    }

    static {
        PERCENT_BOOST_FORMAT.setPositivePrefix("+");
    }
}

