/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.crt.managers.base;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl_native.item.ExpandItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidUtil;
import org.openzen.zencode.java.ZenCodeType;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.container.ContainerFillingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.crt.CRTHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.tconstruct.ICastingManager")
public interface ICastingManager
extends IRecipeManager {
    public ItemCastingRecipe makeItemCastingRecipe(ResourceLocation var1, Ingredient var2, FluidIngredient var3, ItemOutput var4, int var5, boolean var6, boolean var7);

    public ContainerFillingRecipe makeContainerFillingRecipe(ResourceLocation var1, int var2, Item var3);

    public MaterialCastingRecipe makeMaterialCastingRecipe(ResourceLocation var1, Ingredient var2, int var3, IMaterialItem var4, boolean var5, boolean var6);

    public CompositeCastingRecipe makeCompositeCastingRecipe(ResourceLocation var1, IMaterialItem var2, int var3);

    @ZenCodeType.Method
    default public void addItemCastingRecipe(String name, IIngredient cast, CTFluidIngredient fluidIngredient, IItemStack result, int coolingTime, boolean consumeCast, boolean switchSlots) {
        name = this.fixRecipeName(name);
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        Ingredient castIngredient = cast.asVanillaIngredient();
        FluidIngredient fluid = CRTHelper.mapFluidIngredient(fluidIngredient);
        ItemOutput itemOutput = ItemOutput.fromStack((ItemStack)result.getInternal());
        ItemCastingRecipe recipe = this.makeItemCastingRecipe(id, castIngredient, fluid, itemOutput, coolingTime, consumeCast, switchSlots);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Item Casting"));
    }

    @ZenCodeType.Method
    default public void addContainerFillingRecipe(String name, int fluidAmount, Item containerIn) {
        if (!FluidUtil.getFluidHandler((ItemStack)containerIn.func_190903_i()).isPresent()) {
            throw new IllegalArgumentException(ExpandItem.getDefaultInstance((Item)containerIn).getCommandString() + " is not a fluid container!");
        }
        name = this.fixRecipeName(name);
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        ContainerFillingRecipe recipe = this.makeContainerFillingRecipe(id, fluidAmount, containerIn);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Container Filling"));
    }

    @ZenCodeType.Method
    default public void addMaterialCastingRecipe(String name, IIngredient cast, int itemCost, Item result, boolean consumeCast, boolean switchSlots) {
        if (!(result instanceof IMaterialItem)) {
            throw new IllegalArgumentException(ExpandItem.getDefaultInstance((Item)result).getCommandString() + " is not a valid IMaterialItem! You can use `/ct dump ticMaterialItems` to view valid items!");
        }
        name = this.fixRecipeName(name);
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        Ingredient castIngredient = cast.asVanillaIngredient();
        MaterialCastingRecipe recipe = this.makeMaterialCastingRecipe(id, castIngredient, itemCost, (IMaterialItem)result, consumeCast, switchSlots);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Material Casting"));
    }

    @ZenCodeType.Method
    default public void addCompositeCastingRecipe(String name, Item result, int itemCost) {
        if (!(result instanceof IMaterialItem)) {
            throw new IllegalArgumentException(ExpandItem.getDefaultInstance((Item)result).getCommandString() + " is not a valid IMaterialItem! You can use `/ct dump ticMaterialItems` to view valid items!");
        }
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        CompositeCastingRecipe recipe = this.makeCompositeCastingRecipe(id, (IMaterialItem)result, itemCost);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe, "Composite Part Casting"));
    }
}

