/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingCategory
extends AbstractMeltingCategory {
    private static final String KEY_TITLE = TConstruct.makeTranslationKey("jei", "melting.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    private static final ITextComponent SOLID_TEMPERATURE = new TranslationTextComponent(KEY_TEMPERATURE, new Object[]{800}).func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent SOLID_MULTIPLIER = new TranslationTextComponent(KEY_MULTIPLIER, new Object[]{Float.valueOf(0.8f)}).func_240699_a_(TextFormatting.GRAY);
    private static final ITextComponent TOOLTIP_SMELTERY = TConstruct.makeTranslation("jei", "melting.smeltery").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
    private static final ITextComponent TOOLTIP_MELTER = TConstruct.makeTranslation("jei", "melting.melter").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.UNDERLINE});
    private static final ITooltipCallback<ItemStack> ITEM_TOOLTIP = (index, isInput, stack, list) -> {
        if (index == 1) {
            list.add(1, SOLID_TEMPERATURE);
            list.add(2, SOLID_MULTIPLIER);
        }
    };
    private static final ITooltipCallback<FluidStack> FLUID_TOOLTIP = new MeltingFluidCallback(false);
    private static final ITooltipCallback<FluidStack> ORE_FLUID_TOOLTIP = new MeltingFluidCallback(true);
    private final String title;
    private final IDrawable icon;
    private final IDrawableStatic solidFuel;

    public MeltingCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerSmeltery.searedMelter));
        this.title = ForgeI18n.getPattern((String)KEY_TITLE);
        this.solidFuel = helper.drawableBuilder(BACKGROUND_LOC, 164, 0, 18, 20).build();
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.melting;
    }

    @Override
    public void draw(MeltingRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        super.draw(recipe, matrices, mouseX, mouseY);
        int temperature = recipe.getTemperature();
        if (temperature <= 800) {
            this.solidFuel.draw(matrices, 1, 19);
        }
    }

    public void setRecipe(IRecipeLayout layout, MeltingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 23, 17);
        items.set(ingredients);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        fluids.init(0, false, 96, 4, 32, 32, 1296, false, (IDrawable)this.tankOverlay);
        fluids.set(ingredients);
        int fluidHeight = 32;
        if (recipe.getTemperature() <= 800) {
            fluidHeight = 15;
            items.init(1, true, 1, 21);
            items.set(1, (List)MeltingFuelHandler.SOLID_FUELS.get());
            items.addTooltipCallback(ITEM_TOOLTIP);
        }
        fluids.init(-1, true, 4, 4, 12, fluidHeight, 1, false, null);
        fluids.set(-1, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
        fluids.addTooltipCallback(recipe.isOre() ? ORE_FLUID_TOOLTIP : FLUID_TOOLTIP);
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        public MeltingFluidCallback(boolean isOre) {
            super(isOre);
        }

        @Override
        protected boolean addOreTooltip(FluidStack stack, List<ITextComponent> list) {
            list.add(TOOLTIP_SMELTERY);
            boolean shift = FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), IMeltingInventory.applyOreBoost(stack.getAmount(), (Integer)Config.COMMON.smelteryNuggetsPerOre.get()), list);
            list.add(StringTextComponent.field_240750_d_);
            list.add(TOOLTIP_MELTER);
            shift = FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), IMeltingInventory.applyOreBoost(stack.getAmount(), (Integer)Config.COMMON.melterNuggetsPerOre.get()), list) || shift;
            return shift;
        }
    }
}

