/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.world.TinkerWorld;

@Mod.EventBusSubscriber(modid="tconstruct")
public class CommonsEvents {
    private static final String TAG_PLAYER_HAS_BOOK = TConstruct.prefix("spawned_book");

    @SubscribeEvent
    static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        BlockState state;
        Block block;
        if (event.getEntity() == null) {
            return;
        }
        BlockPos pos = new BlockPos(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_());
        if (event.getEntity().func_130014_f_().func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (TinkerWorld.congealedSlime.contains((IForgeRegistryEntry)(block = (state = event.getEntity().func_130014_f_().func_180495_p(pos)).func_177230_c()))) {
            CommonsEvents.bounce(event.getEntity(), 0.25f);
        } else if (TinkerWorld.slimeDirt.contains((IForgeRegistryEntry)block) || TinkerWorld.vanillaSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.earthSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.skySlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.enderSlimeGrass.contains((IForgeRegistryEntry)block) || TinkerWorld.ichorSlimeGrass.contains((IForgeRegistryEntry)block)) {
            CommonsEvents.bounce(event.getEntity(), 0.06f);
        }
    }

    private static void bounce(Entity entity, float amount) {
        entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, (double)amount, 0.0));
        entity.func_184185_a(Sounds.SLIMY_BOUNCE.getSound(), 0.5f + amount, 1.0f);
    }

    @SubscribeEvent
    static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT playerData;
        CompoundNBT data;
        if (((Boolean)Config.COMMON.shouldSpawnWithTinkersBook.get()).booleanValue() && !(data = (playerData = event.getPlayer().getPersistentData()).func_74775_l("PlayerPersisted")).func_74767_n(TAG_PLAYER_HAS_BOOK)) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)event.getPlayer(), (ItemStack)new ItemStack((IItemProvider)TinkerCommons.materialsAndYou.get()));
            data.func_74757_a(TAG_PLAYER_HAS_BOOK, true);
            playerData.func_218657_a("PlayerPersisted", (INBT)data);
        }
    }

    private CommonsEvents() {
    }
}

