/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.world.TinkerWorld;

public class CommonRecipeProvider
extends BaseRecipeProvider
implements ICommonRecipeHelper {
    public CommonRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String func_200397_b() {
        return "Tinkers' Construct Common Recipes";
    }

    @Override
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.addCommonRecipes(consumer);
        this.addMaterialRecipes(consumer);
    }

    private void addCommonRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "common/firewood/";
        this.slabStairsCrafting(consumer, TinkerCommons.blazewood, folder, false);
        this.slabStairsCrafting(consumer, TinkerCommons.lavawood, folder, false);
        this.slabStairsCrafting(consumer, (BuildingBlockObject)TinkerMaterials.nahuatl, folder, false);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)TinkerMaterials.nahuatl.getFence(), (int)6).func_200472_a("WWW").func_200472_a("WWW").func_200462_a(Character.valueOf('W'), (IItemProvider)TinkerMaterials.nahuatl).func_200465_a("has_planks", (ICriterionInstance)CommonRecipeProvider.func_200403_a((IItemProvider)TinkerMaterials.nahuatl)).func_200467_a(consumer, this.modResource(folder + "nahuatl_fence"));
        this.slabStairsCrafting(consumer, TinkerCommons.mudBricks, "common/", false);
        ShapelessRecipeBuilder.func_200486_a(TinkerCommons.materialsAndYou).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(TinkerTables.pattern).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerTables.pattern)).func_200485_a(consumer, this.prefix((Supplier)TinkerCommons.materialsAndYou, "common/"));
        ShapelessRecipeBuilder.func_200486_a(TinkerCommons.tinkersGadgetry).func_200487_b((IItemProvider)Items.field_151122_aG).func_203221_a(SlimeType.SKY.getSlimeballTag()).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200409_a(SlimeType.SKY.getSlimeballTag())).func_200485_a(consumer, this.prefix((Supplier)TinkerCommons.tinkersGadgetry, "common/"));
        ShapelessRecipeBuilder.func_200486_a(TinkerCommons.punySmelting).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(TinkerSmeltery.grout).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerSmeltery.grout)).func_200485_a(consumer, this.prefix((Supplier)TinkerCommons.punySmelting, "common/"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.mightySmelting).setFluidAndTime(TinkerFluids.searedStone, false, 144).setCast((IItemProvider)Items.field_151122_aG, true).build(consumer, this.prefix((Supplier)TinkerCommons.mightySmelting, "common/"));
        ShapelessRecipeBuilder.func_200486_a(TinkerCommons.fantasticFoundry).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b(TinkerSmeltery.netherGrout).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerSmeltery.netherGrout)).func_200485_a(consumer, this.prefix((Supplier)TinkerCommons.fantasticFoundry, "common/"));
        ShapelessRecipeBuilder.func_200486_a(TinkerCommons.encyclopedia).func_200487_b(TinkerCommons.materialsAndYou).func_200487_b(TinkerCommons.punySmelting).func_200487_b(TinkerCommons.mightySmelting).func_200487_b(TinkerCommons.fantasticFoundry).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerCommons.fantasticFoundry)).func_200485_a(consumer, this.prefix((Supplier)TinkerCommons.encyclopedia, "common/"));
        folder = "common/glass/";
        ShapedRecipeBuilder.func_200468_a(TinkerCommons.clearGlassPane, (int)16).func_200462_a(Character.valueOf('#'), TinkerCommons.clearGlass).func_200472_a("###").func_200472_a("###").func_200465_a("has_block", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerCommons.clearGlass)).func_200467_a(consumer, this.prefix((Supplier)TinkerCommons.clearGlassPane, folder));
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            Block block = (Block)TinkerCommons.clearStainedGlass.get((Enum)color);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)block, (int)8).func_200462_a(Character.valueOf('#'), TinkerCommons.clearGlass).func_200469_a(Character.valueOf('X'), (ITag)color.getDye().getTag()).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b(this.modPrefix("stained_clear_glass")).func_200465_a("has_clear_glass", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerCommons.clearGlass)).func_200467_a(consumer, this.prefix((IForgeRegistryEntry)block, folder));
            Block pane = (Block)TinkerCommons.clearStainedGlassPane.get((Enum)color);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)pane, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)block).func_200472_a("###").func_200472_a("###").func_200473_b(this.modPrefix("stained_clear_glass_pane")).func_200465_a("has_block", (ICriterionInstance)CommonRecipeProvider.func_200403_a((IItemProvider)block)).func_200467_a(consumer, this.prefix((IForgeRegistryEntry)pane, folder));
            ShapedRecipeBuilder.func_200468_a((IItemProvider)pane, (int)8).func_200462_a(Character.valueOf('#'), TinkerCommons.clearGlassPane).func_200469_a(Character.valueOf('X'), (ITag)color.getDye().getTag()).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b(this.modPrefix("stained_clear_glass_pane")).func_200465_a("has_clear_glass", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerCommons.clearGlassPane)).func_200467_a(consumer, this.wrap((IForgeRegistryEntry)pane, folder, "_from_panes"));
        }
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151145_ak).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200487_b((IItemProvider)Blocks.field_150351_n).func_200483_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a((IItemProvider)Blocks.field_150351_n)).func_200485_a(ConsumerWrapperBuilder.wrap().addCondition((ICondition)ConfigEnabledCondition.GRAVEL_TO_FLINT).build(consumer), this.modResource("common/flint"));
    }

    private void addMaterialRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "common/materials/";
        this.metalCrafting(consumer, TinkerMaterials.copper, folder);
        this.metalCrafting(consumer, TinkerMaterials.cobalt, folder);
        this.metalCrafting(consumer, TinkerMaterials.slimesteel, folder);
        this.metalCrafting(consumer, TinkerMaterials.tinkersBronze, folder);
        this.metalCrafting(consumer, TinkerMaterials.roseGold, folder);
        this.metalCrafting(consumer, TinkerMaterials.pigIron, folder);
        this.metalCrafting(consumer, TinkerMaterials.queensSlime, folder);
        this.metalCrafting(consumer, TinkerMaterials.manyullyn, folder);
        this.metalCrafting(consumer, TinkerMaterials.hepatizon, folder);
        this.packingRecipe(consumer, "ingot", (IItemProvider)Items.field_234759_km_, "nugget", (IItemProvider)TinkerMaterials.netheriteNugget, folder);
        Item cobaltIngot = TinkerMaterials.cobalt.getIngot();
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerWorld.cobaltOre}), (IItemProvider)cobaltIngot, (float)1.5f, (int)200).func_218628_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerWorld.cobaltOre)).func_218635_a(consumer, this.wrap((IForgeRegistryEntry)cobaltIngot, folder, "_smelting"));
        Item copperIngot = TinkerMaterials.copper.getIngot();
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerWorld.copperOre}), (IItemProvider)copperIngot, (float)1.5f, (int)200).func_218628_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerWorld.copperOre)).func_218635_a(consumer, this.wrap((IForgeRegistryEntry)copperIngot, folder, "_smelting"));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerWorld.copperOre}), (IItemProvider)copperIngot, (float)1.5f, (int)100).func_218628_a("has_item", (ICriterionInstance)CommonRecipeProvider.func_200403_a(TinkerWorld.copperOre)).func_218635_a(consumer, this.wrap((IForgeRegistryEntry)copperIngot, folder, "_blasting"));
    }
}

