/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.component;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.TileEntityHelper;
import slimeknights.tconstruct.library.fluid.FluidTransferUtil;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.component.TankTileEntity;

public class SearedTankBlock
extends SearedBlock
implements TankTileEntity.ITankBlock {
    private final int capacity;

    public SearedTankBlock(AbstractBlock.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new TankTileEntity(this);
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (FluidTransferUtil.interactWithTank(world, pos, player, hand, hit)) {
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TankTileEntity) {
            FluidStack fluid = ((TankTileEntity)te).getTank().getFluid();
            return fluid.getFluid().getAttributes().getLuminosity(fluid);
        }
        return super.getLightValue(state, world, pos);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            TileEntityHelper.getTile(TankTileEntity.class, (IBlockReader)worldIn, (BlockPos)pos).ifPresent(te -> te.updateTank(nbt.func_74775_l("tank")));
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return ITankTileEntity.getComparatorInputOverride((IWorld)worldIn, pos);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        TileEntityHelper.getTile(TankTileEntity.class, (IBlockReader)world, (BlockPos)pos).ifPresent(te -> te.setTankTag(stack));
        return stack;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public static enum TankType implements IStringSerializable
    {
        FUEL_TANK(4000),
        FUEL_GAUGE(4000),
        INGOT_TANK(4608),
        INGOT_GAUGE(4608);

        private final int capacity;

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        private TankType(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }
}

