/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public class CopperCanFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTankCapacity(int tank) {
        return 144;
    }

    private Fluid getFluid() {
        return CopperCanItem.getFluid(this.container);
    }

    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.getFluid(), 144);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getFluid() != Fluids.field_204541_a || resource.getAmount() < 144) {
            return 0;
        }
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, resource.getFluid());
        }
        return 144;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || resource.getAmount() < 144) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.field_204541_a || fluid != resource.getFluid()) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, 144);
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, Fluids.field_204541_a);
        }
        return output;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain < 144) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = this.getFluid();
        if (fluid == Fluids.field_204541_a) {
            return FluidStack.EMPTY;
        }
        FluidStack output = new FluidStack(fluid, 144);
        if (action.execute()) {
            CopperCanItem.setFluid(this.container, Fluids.field_204541_a);
        }
        return output;
    }

    public CopperCanFluidHandler(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

