/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.tconstruct.smeltery.item.CopperCanFluidHandler;

public class CopperCanItem
extends Item {
    private static final String TAG_FLUID = "fluid";

    public CopperCanItem(Item.Properties properties) {
        super(properties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CopperCanFluidHandler(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return CopperCanItem.getFluid(stack) != Fluids.field_204541_a;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        Fluid fluid = CopperCanItem.getFluid(stack);
        if (fluid != Fluids.field_204541_a) {
            return new ItemStack((IItemProvider)this);
        }
        return ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Fluid fluid = CopperCanItem.getFluid(stack);
        if (fluid != Fluids.field_204541_a) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".contents", new Object[]{new TranslationTextComponent(fluid.getAttributes().getTranslationKey())}).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static ItemStack setFluid(ItemStack stack, Fluid fluid) {
        if (fluid == Fluids.field_204541_a) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null) {
                nbt.func_82580_o(TAG_FLUID);
                if (nbt.isEmpty()) {
                    stack.func_77982_d(null);
                }
            }
        } else {
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74778_a(TAG_FLUID, Objects.requireNonNull(fluid.getRegistryName()).toString());
        }
        return stack;
    }

    public static Fluid getFluid(ItemStack stack) {
        Fluid fluid;
        ResourceLocation location;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && (location = ResourceLocation.func_208304_a((String)nbt.func_74779_i(TAG_FLUID))) != null && ForgeRegistries.FLUIDS.containsKey(location) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(location)) != null) {
            return fluid;
        }
        return Fluids.field_204541_a;
    }

    public static String getSubtype(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74779_i(TAG_FLUID);
        }
        return "";
    }
}

