/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.component;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.inventory.SingleItemContainer;
import slimeknights.tconstruct.smeltery.tileentity.component.SmelteryInputOutputTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.inventory.DuctItemHandler;
import slimeknights.tconstruct.smeltery.tileentity.inventory.DuctTankWrapper;
import slimeknights.tconstruct.smeltery.tileentity.tank.IDisplayFluidListener;

public class DuctTileEntity
extends SmelteryInputOutputTileEntity.SmelteryFluidIO
implements INamedContainerProvider {
    private static final String TAG_ITEM = "item";
    private static final ITextComponent TITLE = TConstruct.makeTranslation("gui", "duct");
    private final DuctItemHandler itemHandler = new DuctItemHandler(this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final IModelData modelData = new SinglePropertyData(IDisplayFluidListener.PROPERTY);

    public DuctTileEntity() {
        this((TileEntityType)TinkerSmeltery.duct.get());
    }

    protected DuctTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public ITextComponent func_145748_c_() {
        return TITLE;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new SingleItemContainer(id, inventory, (TileEntity)this);
    }

    @Override
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Override
    protected LazyOptional<IFluidHandler> makeWrapper(LazyOptional<IFluidHandler> capability) {
        return LazyOptional.of(() -> new DuctTankWrapper((IFluidHandler)capability.orElse(this.emptyInstance), this.itemHandler));
    }

    public void updateFluid() {
        Fluid fluid = this.itemHandler.getFluid();
        this.modelData.setData(IDisplayFluidListener.PROPERTY, (Object)fluid);
        this.requestModelDataUpdate();
        assert (this.field_145850_b != null);
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 48);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        if (tags.func_150297_b(TAG_ITEM, 10)) {
            this.itemHandler.readFromNBT(tags.func_74775_l(TAG_ITEM));
        }
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.updateFluid();
        }
    }

    public void writeSynced(CompoundNBT tags) {
        super.writeSynced(tags);
        tags.func_218657_a(TAG_ITEM, (INBT)this.itemHandler.writeToNBT());
    }

    public DuctItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IModelData getModelData() {
        return this.modelData;
    }
}

