/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.controller;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.tileentity.NamableTileEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.inventory.AlloyerContainer;
import slimeknights.tconstruct.smeltery.tileentity.ITankTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.MixerAlloyTank;
import slimeknights.tconstruct.smeltery.tileentity.module.alloying.SingleAlloyingModule;

public class AlloyerTileEntity
extends NamableTileEntity
implements ITankTileEntity,
ITickableTileEntity {
    private static final int TANK_CAPACITY = 3888;
    protected final FluidTankAnimated tank = new FluidTankAnimated(3888, (MantleTileEntity)this);
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    private final MixerAlloyTank alloyTank = new MixerAlloyTank((MantleTileEntity)this, (IFluidHandler)this.tank);
    private final SingleAlloyingModule alloyingModule = new SingleAlloyingModule((MantleTileEntity)this, this.alloyTank);
    private final FuelModule fuelModule = new FuelModule((MantleTileEntity)this, () -> Collections.singletonList(this.field_174879_c.func_177977_b()));
    private int lastStrength = -1;
    private int tick;

    public AlloyerTileEntity() {
        this((TileEntityType)TinkerSmeltery.alloyer.get());
    }

    protected AlloyerTileEntity(TileEntityType<?> type) {
        super(type, (ITextComponent)TConstruct.makeTranslation("gui", "alloyer"));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
    }

    private boolean isFormed() {
        BlockState state = this.func_195044_w();
        return state.func_235901_b_((Property)MelterBlock.IN_STRUCTURE) && (Boolean)state.func_177229_b((Property)MelterBlock.IN_STRUCTURE) != false;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.isFormed()) {
            return;
        }
        switch (this.tick) {
            case 0: {
                this.alloyTank.setTemperature(this.fuelModule.findFuel(false));
                if (this.fuelModule.hasFuel() || !this.alloyingModule.canAlloy()) break;
                this.fuelModule.findFuel(true);
                break;
            }
            case 2: {
                BlockState state = this.func_195044_w();
                boolean hasFuel = this.fuelModule.hasFuel();
                if ((Boolean)state.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    BlockPos down = this.field_174879_c.func_177977_b();
                    BlockState downState = this.field_145850_b.func_180495_p(down);
                    if (TinkerTags.Blocks.FUEL_TANKS.func_230235_a_((Object)downState.func_177230_c()) && downState.func_235901_b_((Property)ControllerBlock.ACTIVE) && (Boolean)downState.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_145850_b.func_175656_a(down, (BlockState)downState.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                }
                if (!hasFuel) break;
                this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                this.alloyingModule.doAlloy();
                this.fuelModule.decreaseFuel(1);
                break;
            }
        }
        this.tick = (this.tick + 1) % 4;
    }

    public void neighborChanged(Direction side) {
        this.alloyTank.refresh(side, true);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity playerEntity) {
        return new AlloyerContainer(id, inv, this);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void writeSynced(CompoundNBT tag) {
        super.writeSynced(tag);
        tag.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.fuelModule.writeToNBT(tag);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.fuelModule.readFromNBT(nbt);
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public MixerAlloyTank getAlloyTank() {
        return this.alloyTank;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }
}

