/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.library.slots;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.JSONUtils;
import slimeknights.mantle.util.JsonHelper;

public class SlotPosition {
    public static final SlotPosition EMPTY = new SlotPosition(0, 0);
    private final int x;
    private final int y;

    public static List<SlotPosition> listFromJson(JsonObject parent, String key) {
        JsonElement json = parent.get(key);
        if (json.isJsonObject()) {
            return Collections.singletonList(SlotPosition.fromJson(json.getAsJsonObject()));
        }
        if (json.isJsonArray()) {
            return JsonHelper.parseList((JsonArray)json.getAsJsonArray(), (String)key, j -> SlotPosition.fromJson(j));
        }
        throw new JsonSyntaxException("Invalid slot '" + key + "', must be an array or an object");
    }

    public static SlotPosition fromJson(JsonObject json, String name) {
        JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)name);
        if (array.size() != 2) {
            throw new JsonParseException("Expected 2 " + name + " values, found: " + array.size());
        }
        int[] vec = new int[2];
        for (int i = 0; i < vec.length; ++i) {
            vec[i] = JSONUtils.func_151215_f((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return new SlotPosition(vec[0], vec[1]);
    }

    public static SlotPosition fromJson(JsonObject json) {
        return SlotPosition.fromJson(json, "position");
    }

    public boolean isHidden() {
        return this.x == -1 && this.y == -1;
    }

    public SlotPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

