/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.client.Icons;
import slimeknights.tconstruct.tables.client.SlotInformationLoader;
import slimeknights.tconstruct.tables.client.inventory.SlotButtonItem;
import slimeknights.tconstruct.tables.client.inventory.library.slots.SlotInformation;
import slimeknights.tconstruct.tables.client.inventory.module.SideButtonsScreen;
import slimeknights.tconstruct.tables.client.inventory.table.TinkerStationScreen;

public class TinkerStationButtonsScreen
extends SideButtonsScreen {
    protected final TinkerStationScreen parent;
    protected int selected = 0;
    private int style = 0;
    public static final int WOOD_STYLE = 2;
    public static final int METAL_STYLE = 1;

    public TinkerStationButtonsScreen(TinkerStationScreen parent, Container container, PlayerInventory playerInventory, ITextComponent title) {
        super(parent, container, playerInventory, title, 5, false);
        this.parent = parent;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        int index = 0;
        this.buttonCount = 0;
        Button.IPressable onPressed = button -> {
            for (Widget widget : this.field_230710_m_) {
                if (!(widget instanceof SlotButtonItem)) continue;
                ((SlotButtonItem)widget).pressed = false;
            }
            if (button instanceof SlotButtonItem) {
                SlotButtonItem slotInformationButton = (SlotButtonItem)button;
                slotInformationButton.pressed = true;
                this.selected = slotInformationButton.buttonId;
                this.parent.onToolSelection(slotInformationButton.data);
            }
        };
        for (SlotInformation slotInformation : SlotInformationLoader.getSlotInformationList()) {
            SlotButtonItem slotButtonItem = null;
            if (slotInformation.isRepair()) {
                if (slotInformation.getPoints().size() == this.parent.getMaxInputs()) {
                    slotButtonItem = new SlotButtonItem(index++, -1, -1, (ITextComponent)new TranslationTextComponent("gui.tconstruct.repair"), slotInformation, onPressed){

                        @Override
                        protected void drawIcon(MatrixStack matrices, Minecraft minecraft) {
                            minecraft.func_110434_K().func_110577_a(Icons.ICONS);
                            Icons.ANVIL.draw(matrices, this.field_230690_l_, this.field_230691_m_);
                        }
                    };
                }
            } else if (slotInformation.getPoints().size() <= this.parent.getMaxInputs()) {
                slotButtonItem = new SlotButtonItem(index++, -1, -1, slotInformation.getToolForRendering(), slotInformation, onPressed);
            }
            if (slotButtonItem == null) continue;
            this.addInfoButton(slotButtonItem);
            if (index - 1 != this.selected) continue;
            slotButtonItem.pressed = true;
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
    }

    public void addInfoButton(SlotButtonItem slotButtonItem) {
        this.shiftButton(slotButtonItem, 0, -18 * this.style);
        this.addSideButton(slotButtonItem);
    }

    public void shiftStyle(int style) {
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof SlotButtonItem)) continue;
            this.shiftButton((SlotButtonItem)widget, 0, -18);
        }
        this.style = style;
    }

    protected void shiftButton(SlotButtonItem button, int xd, int yd) {
        button.setGraphics(Icons.BUTTON.shift(xd, yd), Icons.BUTTON_HOVERED.shift(xd, yd), Icons.BUTTON_PRESSED.shift(xd, yd), Icons.ICONS);
    }

    public List<Widget> getButtons() {
        return this.field_230710_m_;
    }
}

