/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.ItemHandlerSlot;

public class SideInventoryContainer<TILE extends TileEntity>
extends BaseContainer<TILE> {
    private final int columns;
    private final int slotCount;
    protected final LazyOptional<IItemHandler> itemHandler;

    public SideInventoryContainer(ContainerType<?> containerType, int windowId, PlayerInventory inv, @Nullable TILE tile, int x, int y, int columns) {
        this(containerType, windowId, inv, tile, null, x, y, columns);
    }

    public SideInventoryContainer(ContainerType<?> containerType, int windowId, PlayerInventory inv, @Nullable TILE tile, @Nullable Direction inventoryDirection, int x, int y, int columns) {
        super(containerType, windowId, inv, tile);
        this.itemHandler = tile == null ? LazyOptional.of(() -> EmptyHandler.INSTANCE) : tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inventoryDirection);
        IItemHandler handler = (IItemHandler)this.itemHandler.orElse((Object)EmptyHandler.INSTANCE);
        this.slotCount = handler.getSlots();
        this.columns = columns;
        int rows = this.slotCount / columns;
        if (this.slotCount % columns != 0) {
            ++rows;
        }
        int index = 0;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns && index < this.slotCount; ++index, ++c) {
                this.func_75146_a(this.createSlot(handler, index, x + c * 18, y + r * 18));
            }
        }
    }

    protected Slot createSlot(IItemHandler itemHandler, int index, int x, int y) {
        return new ItemHandlerSlot(itemHandler, index, x, y);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

