/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.recipe.TinkerStationRepairRecipe;
import slimeknights.tconstruct.tools.TinkerToolParts;

public class CraftingTableRepairKitRecipe
extends SpecialRecipe {
    public CraftingTableRepairKitRecipe(ResourceLocation id) {
        super(id);
    }

    protected boolean toolMatches(ItemStack stack) {
        Item item = stack.func_77973_b();
        return TinkerTags.Items.MULTIPART_TOOL.func_230235_a_((Object)item) && TinkerTags.Items.DURABILITY.func_230235_a_((Object)item);
    }

    @Nullable
    protected Pair<ToolStack, IMaterial> getRelevantInputs(CraftingInventory inv) {
        ToolStack tool = null;
        IMaterial material = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == TinkerToolParts.repairKit.get()) {
                if (material != null) {
                    return null;
                }
                IMaterial inputMaterial = IMaterialItem.getMaterialFromStack(stack);
                if (inputMaterial == IMaterial.UNKNOWN) {
                    return null;
                }
                material = inputMaterial;
                continue;
            }
            if (this.toolMatches(stack)) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (tool.isBroken() || tool.getDamage() != 0) continue;
                return null;
            }
            return null;
        }
        if (tool == null || material == null) {
            return null;
        }
        return Pair.of(tool, material);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        Pair<ToolStack, IMaterial> inputs = this.getRelevantInputs(inv);
        return inputs != null && TinkerStationRepairRecipe.getRepairIndex((IModifierToolStack)inputs.getFirst(), (IMaterial)inputs.getSecond()) >= 0;
    }

    protected float getRepairAmount(IModifierToolStack tool, IMaterial repairMaterial) {
        MaterialStatsId repairStats = TinkerStationRepairRecipe.getDefaultStatsId(tool, repairMaterial);
        IMaterial primaryMaterial = tool.getMaterial(tool.getDefinition().getRepairParts()[0]);
        float repairAmount = (float)(MaterialRecipe.getRepairDurability(repairMaterial.getIdentifier(), repairStats) * 2) / 3.0f;
        if (repairAmount > 0.0f && repairMaterial != primaryMaterial) {
            repairAmount /= (float)tool.getDefinition().getBaseStatDefinition().getPrimaryHeadWeight();
        }
        return repairAmount;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Pair<ToolStack, IMaterial> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.func_199560_c());
            return ItemStack.field_190927_a;
        }
        ToolStack tool = ((ToolStack)inputs.getFirst()).copy();
        float repairAmount = this.getRepairAmount(tool, (IMaterial)inputs.getSecond());
        if (repairAmount > 0.0f) {
            for (ModifierEntry entry : tool.getModifierList()) {
                repairAmount = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairAmount);
                if (!(repairAmount <= 0.0f)) continue;
                return tool.createStack();
            }
            ToolDamageUtil.repair(tool, (int)repairAmount);
        }
        return tool.createStack();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.craftingTableRepairSerializer.get();
    }
}

