/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.CompoundIngredient;
import slimeknights.mantle.recipe.ingredient.IngredientWithout;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.SpecializedRepairRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.MaterialIds;
import slimeknights.tconstruct.world.TinkerWorld;

public class ToolsRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper,
IToolRecipeHelper {
    public ToolsRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    @Override
    public String func_200397_b() {
        return "Tinkers' Construct Tool Recipes";
    }

    @Override
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.addToolBuildingRecipes(consumer);
        this.addPartRecipes(consumer);
        this.addMaterialsRecipes(consumer);
        this.addMaterialSmeltery(consumer);
    }

    private void addToolBuildingRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "tools/building/";
        String repairFolder = "tools/repair/";
        this.toolBuilding(consumer, (Supplier)TinkerTools.pickaxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.sledgeHammer, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.veinHammer, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.mattock, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.excavator, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.handAxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.broadAxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.kama, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.scythe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.dagger, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.sword, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.cleaver, folder);
        ShapelessRecipeBuilder.func_200486_a(TinkerTools.flintAndBronze).func_200487_b((IItemProvider)Items.field_151145_ak).func_203221_a(TinkerMaterials.tinkersBronze.getIngotTag()).func_200483_a("has_bronze", (ICriterionInstance)ToolsRecipeProvider.func_200409_a(TinkerMaterials.tinkersBronze.getIngotTag())).func_200485_a(consumer, this.prefix((Supplier)TinkerTools.flintAndBronze, folder));
        SpecializedRepairRecipeBuilder.repair(TinkerTools.flintAndBronze, MaterialIds.tinkersBronze).buildRepairKit(consumer, this.wrap((Supplier)TinkerTools.flintAndBronze, repairFolder, "_repair_kit")).build(consumer, this.wrap((Supplier)TinkerTools.flintAndBronze, repairFolder, "_station"));
    }

    private void addPartRecipes(Consumer<IFinishedRecipe> consumer) {
        String partFolder = "tools/parts/";
        String castFolder = "smeltery/casts/";
        this.partRecipes(consumer, (Supplier)TinkerToolParts.repairKit, TinkerSmeltery.repairKitCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.pickaxeHead, TinkerSmeltery.pickaxeHeadCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.hammerHead, TinkerSmeltery.hammerHeadCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.smallAxeHead, TinkerSmeltery.smallAxeHeadCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.broadAxeHead, TinkerSmeltery.broadAxeHeadCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.smallBlade, TinkerSmeltery.smallBladeCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.broadBlade, TinkerSmeltery.broadBladeCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toolBinding, TinkerSmeltery.toolBindingCast, 1, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.largePlate, TinkerSmeltery.largePlateCast, 4, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toolHandle, TinkerSmeltery.toolHandleCast, 1, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toughHandle, TinkerSmeltery.toughHandleCast, 3, partFolder, castFolder);
    }

    private void addMaterialsRecipes(Consumer<IFinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialRecipe(consumer, MaterialIds.wood, Ingredient.func_199805_a((ITag)Tags.Items.RODS_WOODEN), 1, 2, folder + "wood/sticks");
        this.materialRecipe(consumer, MaterialIds.wood, (Ingredient)new IngredientWithout(Ingredient.func_199805_a((ITag)ItemTags.field_199905_b), Ingredient.func_199805_a(TinkerTags.Items.SLIMY_PLANKS)), 1, 1, folder + "wood/planks");
        this.materialRecipe(consumer, MaterialIds.wood, (Ingredient)new IngredientWithout(Ingredient.func_199805_a((ITag)ItemTags.field_200038_h), Ingredient.func_199805_a(TinkerTags.Items.SLIMY_LOGS)), 4, 1, ItemOutput.fromStack((ItemStack)new ItemStack((IItemProvider)Items.field_151055_y, 2)), folder + "wood/logs");
        this.materialRecipe(consumer, MaterialIds.stone, (Ingredient)CompoundIngredient.from((Ingredient[])new Ingredient[]{Ingredient.func_199805_a((ITag)Tags.Items.STONE), Ingredient.func_199805_a((ITag)Tags.Items.COBBLESTONE), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_235406_np_, Blocks.field_235410_nt_})}), 1, 1, folder + "stone");
        this.materialRecipe(consumer, MaterialIds.flint, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151145_ak, Blocks.field_235337_cO_, Blocks.field_235338_cP_}), 1, 1, folder + "flint");
        this.materialRecipe(consumer, MaterialIds.bone, Ingredient.func_199805_a((ITag)Tags.Items.BONES), 1, 1, folder + "bone");
        this.materialRecipe(consumer, MaterialIds.necroticBone, Ingredient.func_199805_a(TinkerTags.Items.WITHER_BONES), 1, 1, folder + "necrotic_bone");
        this.metalMaterialRecipe(consumer, MaterialIds.iron, folder, "iron", false);
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.searedBrick}), 1, 2, folder + "seared_stone/brick");
        this.materialRecipe(consumer, MaterialIds.searedStone, Ingredient.func_199805_a(TinkerTags.Items.SEARED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.searedBrick), folder + "seared_stone/block");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerSmeltery.scorchedBrick}), 1, 2, folder + "scorched_stone/brick");
        this.materialRecipe(consumer, MaterialIds.scorchedStone, Ingredient.func_199805_a(TinkerTags.Items.SCORCHED_BLOCKS), 2, 1, ItemOutput.fromItem(TinkerSmeltery.scorchedBrick), folder + "scorched_stone/block");
        this.metalMaterialRecipe(consumer, MaterialIds.copper, folder, "copper", false);
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a(TinkerTags.Items.SLIMY_PLANKS), 1, 1, folder + "slimewood/planks");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.greenheart.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.greenheart), folder + "slimewood/greenheart_logs");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.skyroot.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.skyroot), folder + "slimewood/skyroot_logs");
        this.materialRecipe(consumer, MaterialIds.slimewood, Ingredient.func_199805_a((ITag)TinkerWorld.bloodshroom.getLogItemTag()), 4, 1, ItemOutput.fromItem((IItemProvider)TinkerWorld.bloodshroom), folder + "slimewood/bloodshroom_logs");
        this.materialRecipe(consumer, MaterialIds.bloodbone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.bloodbone}), 1, 1, folder + "bloodbone");
        this.metalMaterialRecipe(consumer, MaterialIds.roseGold, folder, "rose_gold", false);
        this.metalMaterialRecipe(consumer, MaterialIds.slimesteel, folder, "slimesteel", false);
        this.materialRecipe(consumer, MaterialIds.nahuatl, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.nahuatl}), 1, 1, folder + "nahuatl");
        this.metalMaterialRecipe(consumer, MaterialIds.tinkersBronze, folder, "silicon_bronze", false);
        this.metalMaterialRecipe(consumer, MaterialIds.pigIron, folder, "pig_iron", false);
        this.materialRecipe(consumer, MaterialIds.pigIron, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerCommons.bacon}), 1, 4, folder + "pig_iron/bacon");
        this.metalMaterialRecipe(consumer, MaterialIds.cobalt, folder, "cobalt", false);
        this.metalMaterialRecipe(consumer, MaterialIds.queensSlime, folder, "queens_slime", false);
        this.metalMaterialRecipe(consumer, MaterialIds.manyullyn, folder, "manyullyn", false);
        this.metalMaterialRecipe(consumer, MaterialIds.hepatizon, folder, "hepatizon", false);
        this.materialRecipe(consumer, MaterialIds.blazingBone, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{TinkerMaterials.blazingBone}), 1, 1, folder + "blazing_bone");
        this.metalMaterialRecipe(consumer, MaterialIds.silver, folder, "silver", true);
        this.metalMaterialRecipe(consumer, MaterialIds.lead, folder, "lead", true);
        this.metalMaterialRecipe(consumer, MaterialIds.electrum, folder, "electrum", true);
        this.metalMaterialRecipe(consumer, MaterialIds.bronze, folder, "bronze", true);
        this.metalMaterialRecipe(consumer, MaterialIds.steel, folder, "steel", true);
        this.metalMaterialRecipe(consumer, MaterialIds.constantan, folder, "constantan", true);
    }

    private void addMaterialSmeltery(Consumer<IFinishedRecipe> consumer) {
        String folder = "tools/materials/";
        this.materialMeltingCasting(consumer, MaterialIds.iron, TinkerFluids.moltenIron, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.copper, TinkerFluids.moltenCopper, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.searedStone, TinkerFluids.searedStone, false, 288, folder);
        this.materialMeltingCasting(consumer, MaterialIds.scorchedStone, TinkerFluids.scorchedStone, false, 288, folder);
        this.materialComposite(consumer, MaterialIds.stone, MaterialIds.searedStone, TinkerFluids.moltenClay, 250, false, folder);
        this.materialComposite(consumer, MaterialIds.wood, MaterialIds.slimewood, TinkerFluids.earthSlime, 250, true, folder);
        this.materialComposite(consumer, MaterialIds.flint, MaterialIds.scorchedStone, TinkerFluids.magma, 250, true, folder);
        this.materialComposite(consumer, MaterialIds.bone, MaterialIds.bloodbone, TinkerFluids.blood, 250, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.slimesteel, TinkerFluids.moltenSlimesteel, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.tinkersBronze, TinkerFluids.moltenTinkersBronze, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.roseGold, TinkerFluids.moltenRoseGold, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.pigIron, TinkerFluids.moltenPigIron, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.cobalt, TinkerFluids.moltenCobalt, true, folder);
        this.materialComposite(consumer, MaterialIds.wood, MaterialIds.nahuatl, TinkerFluids.moltenObsidian, 1000, false, folder);
        MaterialMeltingRecipeBuilder.material(MaterialIds.nahuatl, new FluidStack((Fluid)TinkerFluids.moltenObsidian.get(), 1000)).build(consumer, this.modResource(folder + "melting/nahuatl"));
        this.materialMeltingCasting(consumer, MaterialIds.queensSlime, TinkerFluids.moltenQueensSlime, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.hepatizon, TinkerFluids.moltenHepatizon, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.manyullyn, TinkerFluids.moltenManyullyn, true, folder);
        this.materialComposite(consumer, MaterialIds.necroticBone, MaterialIds.blazingBone, TinkerFluids.blazingBlood, 200, false, folder);
        this.materialMeltingCasting(consumer, MaterialIds.lead, TinkerFluids.moltenLead, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.silver, TinkerFluids.moltenSilver, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.electrum, TinkerFluids.moltenElectrum, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.bronze, TinkerFluids.moltenBronze, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.steel, TinkerFluids.moltenSteel, true, folder);
        this.materialMeltingCasting(consumer, MaterialIds.constantan, TinkerFluids.moltenConstantan, true, folder);
    }
}

