/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.internal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableWeapon;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class OffhandAttackModifier
extends SingleUseModifier {
    public static final ResourceLocation DUEL_WIELDING = TConstruct.getResource("duel_wielding");

    public OffhandAttackModifier(int color) {
        super(color);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        volatileData.putBoolean(DUEL_WIELDING, true);
    }

    protected boolean canAttack(IModifierToolStack tool, PlayerEntity player, Hand hand) {
        return hand == Hand.OFF_HAND && OffhandCooldownTracker.isAttackReady((PlayerEntity)player) && tool.getItem() instanceof IModifiableWeapon;
    }

    @Override
    public ActionResultType onEntityUseFirst(IModifierToolStack tool, int level, PlayerEntity player, Entity target, Hand hand) {
        if (this.canAttack(tool, player, hand)) {
            if (!player.field_70170_p.func_201670_d()) {
                ToolAttackUtil.attackEntity((IModifiableWeapon)tool.getItem(), tool, (LivingEntity)player, Hand.OFF_HAND, target, ToolAttackUtil.getCooldownFunction(player, Hand.OFF_HAND), false);
            }
            OffhandCooldownTracker.applyCooldown((PlayerEntity)player, (float)tool.getStats().getFloat(ToolStats.ATTACK_SPEED), (int)20);
            OffhandCooldownTracker.swingHand((LivingEntity)player, (Hand)Hand.OFF_HAND, (boolean)false);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType onToolUse(IModifierToolStack tool, int level, World world, PlayerEntity player, Hand hand) {
        if (this.canAttack(tool, player, hand)) {
            OffhandCooldownTracker.applyCooldown((PlayerEntity)player, (float)tool.getStats().getFloat(ToolStats.ATTACK_SPEED), (int)20);
            OffhandCooldownTracker.swingHand((LivingEntity)player, (Hand)Hand.OFF_HAND, (boolean)false);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }
}

