/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class OverslimeModifier
extends SingleUseModifier {
    private static final String KEY_OVERSLIME_AMOUNT = TConstruct.makeTranslationKey("gui", "amount");
    private static final ResourceLocation KEY_OVERSLIME = TConstruct.getResource("overslime");
    private static final ResourceLocation KEY_OVERSLIME_CAP = TConstruct.getResource("overslime_cap");
    private static final ResourceLocation KEY_OVERSLIME_FRIEND = TConstruct.getResource("overslime_friend");

    public OverslimeModifier() {
        super(7462021);
    }

    @Override
    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        return this.getDisplayName().func_230532_e_().func_240702_b_(": " + this.getOverslime(tool) + " / " + this.getCapacity(tool));
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        this.addCapacity(volatileData, (int)(50.0f * toolDefinition.getBaseStatDefinition().getModifier(ToolStats.DURABILITY)));
    }

    @Override
    public void addToolStats(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, IModDataReadOnly volatileData, int level, ModifierStatsBuilder builder) {
        if (!volatileData.getBoolean(KEY_OVERSLIME_FRIEND)) {
            ToolStats.ATTACK_DAMAGE.multiply(builder, 0.9f);
            ToolStats.MINING_SPEED.multiply(builder, 0.9f);
        }
    }

    @Override
    public ValidatedResult validate(IModifierToolStack tool, int level) {
        if (level > 0) {
            int cap = this.getCapacity(tool);
            if (this.getOverslime(tool) > cap) {
                this.setOverslime(tool, cap);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(this.getId());
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    public int onDamageTool(IModifierToolStack toolStack, int level, int amount) {
        int overslime = this.getOverslime(toolStack);
        if (overslime > 0) {
            if (overslime >= amount) {
                this.setOverslime(toolStack, overslime - amount);
                return 0;
            }
            amount -= overslime;
            this.setOverslime(toolStack, 0);
        }
        return amount;
    }

    @Override
    public double getDamagePercentage(IModifierToolStack tool, int level) {
        int overslime = this.getOverslime(tool);
        if (overslime > 0) {
            int cap = this.getCapacity(tool);
            if (overslime > cap) {
                return 0.0;
            }
            return (double)(cap - overslime) / (double)cap;
        }
        return Double.NaN;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IModifierToolStack tool, int level) {
        return this.getOverslime(tool) < this.getCapacity(tool);
    }

    @Override
    public int getDurabilityRGB(IModifierToolStack tool, int level) {
        if (this.getOverslime(tool) > 0) {
            return 53503;
        }
        return -1;
    }

    public ResourceLocation getOverslimeKey() {
        return KEY_OVERSLIME;
    }

    public ResourceLocation getCapacityKey() {
        return KEY_OVERSLIME_CAP;
    }

    public ResourceLocation getFriendKey() {
        return KEY_OVERSLIME_FRIEND;
    }

    public void setFriend(ModDataNBT volatileData) {
        volatileData.putBoolean(this.getFriendKey(), true);
    }

    public int getCapacity(IModDataReadOnly volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IModifierToolStack tool) {
        return this.getCapacity(tool.getVolatileData());
    }

    public void setCapacity(ModDataNBT volatileData, int amount) {
        volatileData.putInt(KEY_OVERSLIME_CAP, amount);
    }

    public void addCapacity(ModDataNBT volatileData, int amount) {
        this.setCapacity(volatileData, this.getCapacity(volatileData) + amount);
    }

    public void multiplyCapacity(ModDataNBT volatileData, float factor) {
        volatileData.putInt(KEY_OVERSLIME_CAP, (int)((float)this.getCapacity(volatileData) * factor));
    }

    public int getOverslime(IModifierToolStack tool) {
        return tool.getPersistentData().getInt(this.getOverslimeKey());
    }

    @Deprecated
    public void setOverslime(ModDataNBT persistentData, int amount) {
        persistentData.putInt(this.getOverslimeKey(), Math.max(amount, 0));
    }

    public void setOverslime(IModifierToolStack tool, int amount) {
        this.setOverslime(tool.getPersistentData(), Math.min(amount, this.getCapacity(tool)));
    }

    public void addOverslime(IModifierToolStack tool, int amount) {
        this.setOverslime(tool, this.getOverslime(tool) + amount);
    }
}

