/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class InsatibleModifier
extends Modifier {
    public InsatibleModifier() {
        super(9593292);
    }

    @Override
    public float getEntityDamage(IModifierToolStack tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        int effectLevel = ((TinkerEffect)TinkerModifiers.insatiableEffect.get()).getLevel(context.getAttacker()) + 1;
        return damage + (float)(level * effectLevel) / 4.0f * tool.getModifier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)TinkerModifiers.insatiableEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)TinkerModifiers.insatiableEffect.get()).apply(attacker, 100, effectLevel);
        }
        return 0;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        this.addDamageTooltip(tool, level * 2, tooltip);
    }
}

