/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IShearModifier;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.effect.MagneticEffect;

public class MagneticModifier
extends Modifier
implements IHarvestModifier,
IShearModifier {
    public MagneticModifier() {
        super(0x720000);
    }

    @Override
    public void afterBlockBreak(IModifierToolStack tool, int level, ToolHarvestContext context) {
        if (!context.isAOE()) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply(context.getLiving(), 30, level - 1);
        }
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack()) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply(context.getAttacker(), 30, level - 1);
        }
        return 0;
    }

    @Override
    public void afterHarvest(IModifierToolStack tool, int level, ItemUseContext context, ServerWorld world, BlockState state, BlockPos pos) {
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    public void afterShearEntity(IModifierToolStack tool, int level, PlayerEntity player, Entity entity, boolean isTarget) {
        if (isTarget) {
            ((MagneticEffect)TinkerModifiers.magneticEffect.get()).apply((LivingEntity)player, 30, level - 1);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        if (type == IHarvestModifier.class || type == IShearModifier.class) {
            return (T)this;
        }
        return null;
    }
}

