/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.RecipeSerializer;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.salvage.AbstractModifierSalvage;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRemovalRecipe
implements ITinkerStationRecipe {
    private static final ValidatedResult NO_MODIFIERS = ValidatedResult.failure(TConstruct.makeTranslationKey("recipe", "remove_modifier.no_modifiers"), new Object[0]);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack container;

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)inv.getTinkerableStack().func_77973_b())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Nullable
    private ModifierEntry getModifierToRemove(ITinkerStationInventory inv, List<ModifierEntry> modifiers) {
        int removeIndex = -1;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b() || !this.ingredient.test(stack)) continue;
            removeIndex += (i + 1) * stack.func_190916_E();
        }
        if (removeIndex == -1) {
            return null;
        }
        removeIndex = removeIndex >= modifiers.size() ? 0 : modifiers.size() - removeIndex - 1;
        return modifiers.get(removeIndex);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationInventory inv) {
        ValidatedResult validated;
        int newLevel;
        Modifier modifier;
        ItemStack toolStack = inv.getTinkerableStack();
        ToolStack tool = ToolStack.from(toolStack);
        List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
        if (modifiers.isEmpty()) {
            return NO_MODIFIERS;
        }
        ModifierEntry toRemove = this.getModifierToRemove(inv, modifiers);
        if (toRemove == null) {
            return ValidatedResult.PASS;
        }
        AbstractModifierSalvage salvage = ModifierRecipeLookup.getSalvage(toolStack, tool = tool.copy(), modifier = toRemove.getModifier(), toRemove.getLevel());
        if (salvage != null) {
            salvage.updateTool(tool);
        }
        if ((newLevel = tool.getModifierLevel(modifier) - 1) <= 0) {
            modifier.beforeRemoved(tool, tool.getRestrictedNBT());
        }
        tool.removeModifier(modifier, 1);
        if (newLevel <= 0) {
            modifier.onRemoved(tool);
        }
        if ((validated = tool.validate()).hasError()) {
            return validated;
        }
        if (newLevel <= 0 && (validated = modifier.validate(tool, 0)).hasError()) {
            return validated;
        }
        ItemStack resultStack = tool.createStack();
        validated = ModifierRecipeLookup.checkRequirements(resultStack, tool);
        if (validated.hasError()) {
            return validated;
        }
        return ValidatedResult.success(resultStack);
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationInventory inv, boolean isServer) {
        AbstractModifierSalvage salvage;
        ItemStack toolStack;
        ToolStack tool;
        ModifierEntry toRemove;
        if (isServer && (toRemove = this.getModifierToRemove(inv, (tool = ToolStack.from(toolStack = inv.getTinkerableStack())).getUpgrades().getModifiers())) != null && (salvage = ModifierRecipeLookup.getSalvage(toolStack, tool, toRemove.getModifier(), toRemove.getLevel())) != null) {
            salvage.acceptItems(tool, inv::giveItem, TConstruct.RANDOM);
        }
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b() || !this.ingredient.test(stack)) continue;
            inv.shrinkInput(i, 1, this.container.func_77946_l());
            break;
        }
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.removeModifierSerializer.get();
    }

    public ModifierRemovalRecipe(ResourceLocation id, Ingredient ingredient, ItemStack container) {
        this.id = id;
        this.ingredient = ingredient;
        this.container = container;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Builder
    extends AbstractRecipeBuilder<Builder> {
        private final Ingredient ingredient;
        private final ItemStack container;

        public void build(Consumer<IFinishedRecipe> consumer) {
            this.build(consumer, Objects.requireNonNull(this.container.func_77973_b().getRegistryName()));
        }

        public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
            if (this.ingredient == Ingredient.field_193370_a) {
                throw new IllegalStateException("Empty ingredient not allowed");
            }
            ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
            consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId));
        }

        private Builder(Ingredient ingredient, ItemStack container) {
            this.ingredient = ingredient;
            this.container = container;
        }

        public static Builder removal(Ingredient ingredient, ItemStack container) {
            return new Builder(ingredient, container);
        }

        private class FinishedRecipe
        extends AbstractRecipeBuilder.AbstractFinishedRecipe {
            public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
                super((AbstractRecipeBuilder)Builder.this, ID, advancementID);
            }

            public void func_218610_a(JsonObject json) {
                json.add("ingredient", Builder.this.ingredient.func_200304_c());
                if (!Builder.this.container.func_190926_b()) {
                    json.add("container", IncrementalModifierRecipeBuilder.serializeResult(Builder.this.container));
                }
            }

            public IRecipeSerializer<?> func_218609_c() {
                return (IRecipeSerializer)TinkerModifiers.removeModifierSerializer.get();
            }
        }
    }

    public static class Serializer
    extends RecipeSerializer<ModifierRemovalRecipe> {
        public ModifierRemovalRecipe read(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
            ItemStack container = ItemStack.field_190927_a;
            if (json.has("container")) {
                container = IncrementalModifierRecipe.deseralizeResultItem(json, "container");
            }
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        @Nullable
        public ModifierRemovalRecipe read(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack container = buffer.func_150791_c();
            return new ModifierRemovalRecipe(id, ingredient, container);
        }

        public void write(PacketBuffer buffer, ModifierRemovalRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.container);
        }
    }
}

