/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import java.io.IOException;
import net.minecraft.client.resources.ColorMapLoader;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class SlimeColorReloadListener
extends ReloadListener<int[]> {
    private final SlimeType color;
    private final ResourceLocation path;

    public SlimeColorReloadListener(SlimeType color) {
        this.color = color;
        this.path = TConstruct.getResource("textures/colormap/" + color.func_176610_l() + "_grass_color.png");
    }

    protected int[] prepare(IResourceManager resourceManager, IProfiler profiler) {
        if (!ModLoader.isLoadingStateValid()) {
            return new int[0];
        }
        try {
            return ColorMapLoader.func_217820_a((IResourceManager)resourceManager, (ResourceLocation)this.path);
        }
        catch (IOException ioexception) {
            TConstruct.LOG.error("Failed to load slime colors", (Throwable)ioexception);
            return new int[0];
        }
    }

    protected void apply(int[] buffer, IResourceManager resourceManager, IProfiler profiler) {
        if (buffer.length != 0) {
            SlimeColorizer.setGrassColor(this.color, buffer);
        }
    }
}

