/*
 * Decompiled with CFR 0.152.
 */
package timeless_and_classic.client.handlers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import timeless_and_classic.client.handlers.TimelessWorkbenchRecipeH;

public class RecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TimelessWorkbenchRecipeH> {
    public TimelessWorkbenchRecipeH read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = JSONUtils.func_151214_t((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject itemObject = input.get(i).getAsJsonObject();
            ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)itemObject);
            builder.add((Object)stack);
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing vehicle entry");
        }
        JsonObject resultObject = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack resultItem = ShapedRecipe.func_199798_a((JsonObject)resultObject);
        return new TimelessWorkbenchRecipeH(recipeId, resultItem, (ImmutableList<ItemStack>)builder.build(), group);
    }

    @Nullable
    public TimelessWorkbenchRecipeH read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_218666_n();
        ItemStack result = buffer.func_150791_c();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)buffer.func_150791_c());
        }
        return new TimelessWorkbenchRecipeH(recipeId, result, (ImmutableList<ItemStack>)builder.build(), group);
    }

    public void write(PacketBuffer buffer, TimelessWorkbenchRecipeH recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        buffer.func_150788_a(recipe.getItem());
        buffer.func_150787_b(recipe.getMaterials().size());
        for (ItemStack stack : recipe.getMaterials()) {
            buffer.func_150788_a(stack);
        }
    }
}

