/*
 * Decompiled with CFR 0.152.
 */
package timeless_and_classic.common.network;

import com.mrcrayfish.guns.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import timeless_and_classic.common.network.HHandshakeUtilities;
import timeless_and_classic.common.network.MessageUtilities;
import timeless_and_classic.common.network.messages.FiremodeMessage;
import timeless_and_classic.common.network.messages.NotifiCraft;

public class HPacket {
    public static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel handshakeChannel;
    private static SimpleChannel playChannel;
    private static int nextMessageId;

    public static void init() {
        handshakeChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("timeless_and_classic", "handshake")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        handshakeChannel.messageBuilder(MessageUtilities.C2SAcknowledge.class, 99).loginIndex(MessageUtilities.LoginIndexedMessage::getLoginIndex, MessageUtilities.LoginIndexedMessage::setLoginIndex).decoder(MessageUtilities.C2SAcknowledge::decode).encoder(MessageUtilities.C2SAcknowledge::encode).consumer(FMLHandshakeHandler.indexFirst((handler, msg, s) -> HHandshakeUtilities.handleAcknowledge(msg, s))).add();
        handshakeChannel.messageBuilder(MessageUtilities.S2CUpdateGuns.class, 1).loginIndex(MessageUtilities.LoginIndexedMessage::getLoginIndex, MessageUtilities.LoginIndexedMessage::setLoginIndex).decoder(MessageUtilities.S2CUpdateGuns::decode).encoder(MessageUtilities.S2CUpdateGuns::encode).consumer(FMLHandshakeHandler.biConsumerFor((handler, msg, supplier) -> HHandshakeUtilities.handleUpdateGuns(msg, supplier))).markAsLoginPacket().add();
        playChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("timeless_and_classic", "play")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        HPacket.registerPlayMessage(NotifiCraft.class, NotifiCraft::new, LogicalSide.SERVER);
        HPacket.registerPlayMessage(FiremodeMessage.class, FiremodeMessage::new, LogicalSide.SERVER);
    }

    private static <T extends IMessage> void registerPlayMessage(Class<T> clazz, Supplier<T> messageSupplier, LogicalSide side) {
        playChannel.registerMessage(nextMessageId++, clazz, IMessage::encode, buffer -> {
            IMessage t = (IMessage)messageSupplier.get();
            t.decode(buffer);
            return t;
        }, (t, supplier) -> {
            if (((NetworkEvent.Context)supplier.get()).getDirection().getReceptionSide() != side) {
                throw new RuntimeException("Attempted to handle message " + clazz.getSimpleName() + " on the wrong logical side!");
            }
            t.handle(supplier);
        });
    }

    public static SimpleChannel getHandshakeChannel() {
        return handshakeChannel;
    }

    public static SimpleChannel getPlayChannel() {
        return playChannel;
    }

    static {
        nextMessageId = 0;
    }
}

