/*
 * Decompiled with CFR 0.152.
 */
package timeless_and_classic.core.types;

import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import timeless_and_classic.core.Config;

public class TimelessGunItem
extends GunItem {
    public TimelessGunItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flag) {
        float additionalDamage;
        Gun modifiedGun = this.getModifiedGun(stack);
        Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (ammo != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cgm.ammo_type", new Object[]{new TranslationTextComponent(ammo.func_77658_a()).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        String additionalDamageText = "";
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("AdditionalDamage", 99)) {
            additionalDamage = tagCompound.func_74760_g("AdditionalDamage");
            if ((additionalDamage += GunModifierHelper.getAdditionalDamage((ItemStack)stack)) > 0.0f) {
                additionalDamageText = TextFormatting.GREEN + " +" + ItemStack.field_111284_a.format(additionalDamage);
            } else if (additionalDamage < 0.0f) {
                additionalDamageText = TextFormatting.RED + " " + ItemStack.field_111284_a.format(additionalDamage);
            }
        }
        additionalDamage = modifiedGun.getProjectile().getDamage();
        additionalDamage = GunModifierHelper.getModifiedProjectileDamage((ItemStack)stack, (float)additionalDamage);
        additionalDamage = GunEnchantmentHelper.getAcceleratorDamage((ItemStack)stack, (float)additionalDamage);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.cgm.damage", new Object[]{TextFormatting.GOLD + ItemStack.field_111284_a.format(additionalDamage) + additionalDamageText}).func_240699_a_(TextFormatting.DARK_GRAY));
        if (tagCompound != null) {
            if (tagCompound.func_74767_n("IgnoreAmmo")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("info.cgm.ignore_ammo").func_240699_a_(TextFormatting.AQUA));
            } else {
                int ammoCount = tagCompound.func_74762_e("AmmoCount");
                tooltip.add((ITextComponent)new TranslationTextComponent("info.cgm.ammo", new Object[]{TextFormatting.GOLD.toString() + ammoCount + "/" + GunEnchantmentHelper.getAmmoCapacity((ItemStack)stack, (Gun)modifiedGun)}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        boolean auto = modifiedGun.getGeneral().isAuto();
        int autoRate = modifiedGun.getGeneral().getRate();
        if (auto) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.timeless_and_classic.auto", new Object[]{TextFormatting.GOLD.toString() + "This weapon is automatic!"}).func_240699_a_(TextFormatting.RED));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("info.cgm.attachment_help", new Object[]{new KeybindTextComponent("key.cgm.attachments").getString().toUpperCase(Locale.ENGLISH)}).func_240699_a_(TextFormatting.YELLOW));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Objects.requireNonNull(TextFormatting.GOLD.func_211163_e());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (((Boolean)Config.COMMON.ammoProgressBar.get()).booleanValue()) {
            CompoundNBT tagCompound = stack.func_196082_o();
            Gun modifiedGun = this.getModifiedGun(stack);
            return !tagCompound.func_74767_n("IgnoreAmmo") && tagCompound.func_74762_e("AmmoCount") != GunEnchantmentHelper.getAmmoCapacity((ItemStack)stack, (Gun)modifiedGun);
        }
        return false;
    }
}

