/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import mcjty.rftoolspower.modules.blazing.items.BlazingRodStack;
import mcjty.rftoolspower.modules.blazing.logic.BlazingAgitatorAlgorithm;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlazingAgitatorTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static int BUFFER_SIZE = 9;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(BUFFER_SIZE * 2).box(SlotDefinition.specific(BlazingAgitatorTileEntity::isValidBlazingRod).in(), "container", 0, 28, 7, 3, 3).box(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get())}).out(), "container", BUFFER_SIZE, 117, 7, 3, 3).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.AGITATOR_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.AGITATOR_ENERGY_INPUT_PERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> this.infusable);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Agitator").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)BlazingModule.CONTAINER_BLAZING_AGITATOR.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage));
    public static VoxelShape SLAB = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    public static final Key<Boolean> VALUE_LOCK_00 = new Key("lock00", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_01 = new Key("lock01", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_02 = new Key("lock02", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_10 = new Key("lock10", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_11 = new Key("lock11", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_12 = new Key("lock12", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_20 = new Key("lock20", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_21 = new Key("lock21", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOCK_22 = new Key("lock22", Type.BOOLEAN);
    private float[] rotationSpeed = new float[9];
    private float[] currentAngle = new float[9];
    private int updateSpeedCounter = 10;
    private BlazingAgitatorAlgorithm algorithm;
    private boolean[] locked = new boolean[BUFFER_SIZE];

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_LOCK_00, () -> this.isLocked(0, 0), b -> this.setLocked(0, 0, (boolean)b)), new DefaultValue(VALUE_LOCK_01, () -> this.isLocked(0, 1), b -> this.setLocked(0, 1, (boolean)b)), new DefaultValue(VALUE_LOCK_02, () -> this.isLocked(0, 2), b -> this.setLocked(0, 2, (boolean)b)), new DefaultValue(VALUE_LOCK_10, () -> this.isLocked(1, 0), b -> this.setLocked(1, 0, (boolean)b)), new DefaultValue(VALUE_LOCK_11, () -> this.isLocked(1, 1), b -> this.setLocked(1, 1, (boolean)b)), new DefaultValue(VALUE_LOCK_12, () -> this.isLocked(1, 2), b -> this.setLocked(1, 2, (boolean)b)), new DefaultValue(VALUE_LOCK_20, () -> this.isLocked(2, 0), b -> this.setLocked(2, 0, (boolean)b)), new DefaultValue(VALUE_LOCK_21, () -> this.isLocked(2, 1), b -> this.setLocked(2, 1, (boolean)b)), new DefaultValue(VALUE_LOCK_22, () -> this.isLocked(2, 2), b -> this.setLocked(2, 2, (boolean)b))};
    }

    public BlazingAgitatorTileEntity() {
        super((TileEntityType)BlazingModule.TYPE_BLAZING_AGITATOR.get());
        this.algorithm = new BlazingAgitatorAlgorithm(slot -> new BlazingRodStack(this.items.getStackInSlot(slot.intValue())));
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazingagitator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingAgitatorTileEntity::new)){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
                return SLAB;
            }
        };
    }

    private static boolean isValidBlazingRod(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151072_bj) {
            return true;
        }
        if (stack.func_77973_b() == BlazingModule.BLAZING_ROD.get()) {
            return BlazingRod.getInfusionStepsLeft(stack) >= 64;
        }
        return false;
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
        super.writeClientDataToNBT(tagCompound);
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            tagCompound.func_74776_a("rs" + i, this.rotationSpeed[i]);
        }
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
        super.readClientDataFromNBT(tagCompound);
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            this.rotationSpeed[i] = tagCompound.func_74760_g("rs" + i);
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean active = false;
            if (this.isMachineEnabled() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue()) {
                this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.AGITATOR_USE_PER_TICK.get()).intValue());
                active = true;
                this.tickRods();
            }
            this.updateClientRotationSpeed(active);
        }
    }

    private void tickRods() {
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == Items.field_151072_bj) {
                this.items.setStackInSlot(i, new ItemStack((IItemProvider)BlazingModule.BLAZING_ROD.get()));
            } else {
                float timeLeft = BlazingRod.getAgitationTimeLeft(stack);
                if (timeLeft > 0.0f) {
                    this.algorithm.tickBlazingRod(i, new BlazingRodStack(stack), timeLeft, this.infusable.getInfusedFactor());
                } else if (!this.locked[i]) {
                    this.moveToOutput(i, stack);
                }
            }
            this.markDirtyQuick();
        }
    }

    private void updateClientRotationSpeed(boolean active) {
        --this.updateSpeedCounter;
        if (this.updateSpeedCounter < 0) {
            this.updateSpeedCounter = 10;
            boolean changed = false;
            for (int i = 0; i < BUFFER_SIZE; ++i) {
                ItemStack stack;
                float newspeed = 0.0f;
                if (active && !(stack = this.items.getStackInSlot(i)).func_190926_b()) {
                    float percentage = BlazingRod.getAgitationTimePercentage(stack);
                    newspeed = percentage / 50.0f;
                }
                if (!((double)Math.abs(newspeed - this.rotationSpeed[i]) > 0.01)) continue;
                this.rotationSpeed[i] = newspeed;
                changed = true;
            }
            if (changed) {
                BlockState state = this.func_195044_w();
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 6);
            }
        }
    }

    private void moveToOutput(int i, ItemStack stack) {
        for (int j = BUFFER_SIZE; j < BUFFER_SIZE + BUFFER_SIZE; ++j) {
            if (!this.items.getStackInSlot(j).func_190926_b()) continue;
            this.items.setStackInSlot(i, ItemStack.field_190927_a);
            this.items.setStackInSlot(j, stack);
            return;
        }
    }

    public float getCurrentAngle(int x, int y) {
        return this.currentAngle[y * 3 + x];
    }

    public void setCurrentAngle(int x, int y, float currentAngle) {
        this.currentAngle[y * 3 + x] = currentAngle;
    }

    public float getRotationSpeed(int x, int y) {
        return this.rotationSpeed[y * 3 + x];
    }

    public boolean isLocked(int x, int y) {
        return this.locked[y * 3 + x];
    }

    public void setLocked(int x, int y, boolean v) {
        this.locked[y * 3 + x] = v;
        this.markDirtyClient();
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        byte[] bytes = info.func_74770_j("locked");
        if (bytes.length >= BUFFER_SIZE) {
            for (int i = 0; i < BUFFER_SIZE; ++i) {
                this.locked[i] = bytes[i] != 0;
            }
        }
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        byte[] bytes = new byte[BUFFER_SIZE];
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            bytes[i] = (byte)(this.locked[i] ? 1 : 0);
        }
        info.func_74773_a("locked", bytes);
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BlazingAgitatorTileEntity.isValidBlazingRod(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

