/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic;

import net.minecraftforge.common.ForgeConfigSpec;

public class EndergenicConfiguration {
    public static final String CATEGORY_ENDERGENIC = "endergenic";
    public static ForgeConfigSpec.IntValue MAXENERGY;
    public static ForgeConfigSpec.IntValue chanceLost;
    public static ForgeConfigSpec.IntValue rfToHoldPearl;
    public static ForgeConfigSpec.IntValue ENDERGENIC_KEEPRF;
    public static ForgeConfigSpec.IntValue ENDERGENIC_SENDPERTICK;
    public static ForgeConfigSpec.IntValue goodParticleCount;
    public static ForgeConfigSpec.IntValue badParticleCount;
    public static ForgeConfigSpec.DoubleValue powergenFactor;

    public static void setup(ForgeConfigSpec.Builder SERVER_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        SERVER_BUILDER.comment("Settings for the endergenic generator").push(CATEGORY_ENDERGENIC);
        CLIENT_BUILDER.comment("Settings for the endergenic generator").push(CATEGORY_ENDERGENIC);
        MAXENERGY = SERVER_BUILDER.comment("Maximum amount of power the endergenic can store").defineInRange("endergenicMaxPower", 5000000, 0, Integer.MAX_VALUE);
        chanceLost = SERVER_BUILDER.comment("The chance (in 1/10 percent, so 1000 = 100%) that an endergenic pearl is lost while trying to hold it").defineInRange("endergenicChanceLost", 5, 0, 1000);
        rfToHoldPearl = SERVER_BUILDER.comment("The amount of RF that is consumed every tick to hold the endergenic pearl").defineInRange("endergenicRfHolding", 500, 0, Integer.MAX_VALUE);
        ENDERGENIC_KEEPRF = SERVER_BUILDER.comment("The amount of RF that every endergenic will keep itself (so that it can hold pearls)").defineInRange("endergenicKeepRf", 2000, 0, Integer.MAX_VALUE);
        ENDERGENIC_SENDPERTICK = SERVER_BUILDER.comment("The amount of RF per tick that this generator can give from its internal buffer to adjacent blocks").defineInRange("endergenicSendPerTick", 20000, 0, Integer.MAX_VALUE);
        goodParticleCount = SERVER_BUILDER.comment("The amount of particles to spawn whenever energy is generated (use 0 to disable)").defineInRange("endergenicGoodParticles", 10, 0, 1000);
        badParticleCount = SERVER_BUILDER.comment("The amount of particles to spawn whenever a pearl is lost (use 0 to disable)").defineInRange("endergenicBadParticles", 10, 0, 1000);
        powergenFactor = SERVER_BUILDER.comment("Multiplier for power generation").defineInRange("powergenFactor", 2.0, 0.0, 1.0E9);
        SERVER_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }
}

