/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderGlowEffect;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.modules.hud.client.HudRenderer;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class EndergenicRenderer
extends TileEntityRenderer<EndergenicTileEntity> {
    public static final ResourceLocation HALO = new ResourceLocation("rftoolspower", "block/endergenic/floatingpearl");
    public static final ResourceLocation WHITEFLASH = new ResourceLocation("rftoolspower", "block/endergenic/whiteflash");
    public static final ResourceLocation BLACKFLASH = new ResourceLocation("rftoolspower", "block/endergenic/redflash");
    public static final ResourceLocation REDGLOW = new ResourceLocation("rftoolspower", "block/endergenic/redglow");
    public static final ResourceLocation BLUEGLOW = new ResourceLocation("rftoolspower", "block/endergenic/blueglow");
    public static final RenderSettings FLASH_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).build();

    public EndergenicRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(EndergenicTileEntity tileEntity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean showOverlay;
        BlockPos coord = tileEntity.func_174877_v();
        if (coord.equals((Object)RFToolsBase.instance.clientInfo.getSelectedTE())) {
            RenderGlowEffect.renderGlow((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (ResourceLocation)REDGLOW);
        } else if (coord.equals((Object)RFToolsBase.instance.clientInfo.getDestinationTE())) {
            RenderGlowEffect.renderGlow((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (ResourceLocation)BLUEGLOW);
        }
        float s = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        if (s > 0.5f) {
            s = 1.0f - s;
        }
        RenderHelper.renderBillboardQuadBright((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (float)(0.2f + s * 0.3f), (ResourceLocation)HALO);
        if (tileEntity.getGoodCounter() > 0) {
            RenderHelper.renderBillboardQuadBright((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (float)(0.8f * ((float)tileEntity.getGoodCounter() / 10.0f)), (ResourceLocation)WHITEFLASH, (RenderSettings)FLASH_SETTINGS);
        }
        if (tileEntity.getBadCounter() > 0) {
            RenderHelper.renderBillboardQuadBright((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (float)(0.8f * ((float)tileEntity.getBadCounter() / 20.0f)), (ResourceLocation)BLACKFLASH, (RenderSettings)FLASH_SETTINGS);
        }
        ItemStack mainHand = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        ItemStack offHand = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
        boolean bl = showOverlay = !mainHand.func_190926_b() && mainHand.func_77973_b() instanceof SmartWrenchItem || !offHand.func_190926_b() && offHand.func_77973_b() instanceof SmartWrenchItem;
        if (showOverlay) {
            HudRenderer.renderHud((MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (IHudSupport)tileEntity);
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)EndergenicModule.TYPE_ENDERGENIC.get()), EndergenicRenderer::new);
    }
}

