/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockFluidPipe;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.FluidPipeTileEntity;
import com.mrcrayfish.vehicle.tileentity.FluidPumpTileEntity;
import com.mrcrayfish.vehicle.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeverBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockFluidPump
extends BlockFluidPipe {
    private final VoxelShape[][] PUMP_BOX = new VoxelShape[][]{{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.func_208617_a((double)4.5, (double)3.0, (double)4.5, (double)11.5, (double)4.0, (double)11.5)}, {Block.func_208617_a((double)3.0, (double)16.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.func_208617_a((double)4.5, (double)13.0, (double)4.5, (double)11.5, (double)12.0, (double)11.5)}, {Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0), Block.func_208617_a((double)4.5, (double)4.5, (double)3.0, (double)11.5, (double)11.5, (double)4.0)}, {Block.func_208617_a((double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0, (double)13.0), Block.func_208617_a((double)4.5, (double)4.5, (double)13.0, (double)11.5, (double)11.5, (double)12.0)}, {Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0), Block.func_208617_a((double)3.0, (double)4.5, (double)4.5, (double)4.0, (double)11.5, (double)11.5)}, {Block.func_208617_a((double)16.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.func_208617_a((double)13.0, (double)4.5, (double)4.5, (double)12.0, (double)11.5, (double)11.5)}};

    @Override
    protected VoxelShape getPipeShape(BlockState state, IBlockReader worldIn, BlockPos pos) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        shapes.add(super.getPipeShape(state, worldIn, pos));
        Collections.addAll(shapes, this.PUMP_BOX[this.getCollisionFacing(state).func_176745_a()]);
        return VoxelShapeHelper.combineAll(shapes);
    }

    @Override
    protected Direction getCollisionFacing(BlockState state) {
        return ((Direction)state.func_177229_b((Property)DIRECTION)).func_176734_d();
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (super.func_225533_a_(state, world, pos, player, hand, result) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        FluidPipeTileEntity pipe = BlockFluidPump.getPipeTileEntity((IBlockReader)world, pos);
        AxisAlignedBB housingBox = this.getHousingBox(pos, state, player, hand, result.func_216347_e().func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())), pipe);
        if (pipe != null && housingBox != null) {
            if (!world.field_72995_K) {
                ((FluidPumpTileEntity)pipe).cyclePowerMode(player);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public AxisAlignedBB getHousingBox(BlockPos pos, BlockState state, PlayerEntity player, Hand hand, Vector3d hitVec, @Nullable FluidPipeTileEntity pipe) {
        VoxelShape[] boxesHousing;
        if (!(pipe instanceof FluidPumpTileEntity) || player.func_184586_b(hand).func_77973_b() != ModItems.WRENCH.get()) {
            return null;
        }
        for (VoxelShape box : boxesHousing = this.PUMP_BOX[this.getCollisionFacing(state).func_176745_a()]) {
            AxisAlignedBB boundingBox = box.func_197752_a();
            if (!boundingBox.func_186662_g(0.001).func_72318_a(hitVec)) continue;
            for (VoxelShape box2 : boxesHousing) {
                boundingBox = boundingBox.func_111270_a(box2.func_197752_a());
            }
            return boundingBox.func_186670_a(pos);
        }
        return null;
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        return this.getPumpState(world, pos, state, (Direction)state.func_177229_b((Property)DIRECTION));
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)super.func_196258_a(context).func_206870_a((Property)DIRECTION, (Comparable)context.func_196000_l());
        return this.getPumpState((IWorld)context.func_195991_k(), context.func_195995_a(), state, context.func_196000_l());
    }

    private BlockState getPumpState(IWorld world, BlockPos pos, BlockState state, Direction originalFacing) {
        FluidPipeTileEntity pipe = BlockFluidPump.getPipeTileEntity((IBlockReader)world, pos);
        boolean[] disabledConnections = FluidPipeTileEntity.getDisabledConnections(pipe);
        for (Direction facing : Direction.values()) {
            boolean enabled;
            if (facing == originalFacing.func_176734_d()) continue;
            state = (BlockState)state.func_206870_a((Property)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
            BlockPos adjacentPos = pos.func_177972_a(facing);
            BlockState adjacentState = world.func_180495_p(adjacentPos);
            boolean bl = enabled = !disabledConnections[facing.func_176745_a()];
            if (adjacentState.func_177230_c() == ModBlocks.FLUID_PIPE.get()) {
                state = (BlockState)state.func_206870_a((Property)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
                continue;
            }
            if (adjacentState.func_177230_c() == Blocks.field_150442_at) {
                Direction leverFacing = ((Direction)adjacentState.func_177229_b((Property)LeverBlock.field_185512_D)).func_176734_d();
                if (!adjacentPos.func_177972_a(leverFacing).equals((Object)pos)) continue;
                state = (BlockState)state.func_206870_a((Property)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(true));
                if (pipe == null) continue;
                pipe.setConnectionDisabled(facing, false);
                continue;
            }
            if (adjacentState.func_177230_c() == this) continue;
            TileEntity tileEntity = world.func_175625_s(adjacentPos);
            state = (BlockState)state.func_206870_a((Property)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled && tileEntity != null && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()).isPresent()));
        }
        return state;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FluidPumpTileEntity();
    }
}

