/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.RayTraceFunction;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageInteractKey;
import com.mrcrayfish.vehicle.network.message.MessagePickupVehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EntityRayTracer {
    private static EntityRayTracer instance;
    private final Map<EntityType<? extends IEntityRayTraceable>, IRayTraceTransforms> entityRayTraceTransforms = new HashMap<EntityType<? extends IEntityRayTraceable>, IRayTraceTransforms>();
    private final Map<EntityType<? extends IEntityRayTraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRayTraceTrianglesStatic = new HashMap<EntityType<? extends IEntityRayTraceable>, Map<RayTracePart, TriangleRayTraceList>>();
    private final Map<EntityType<? extends IEntityRayTraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRayTraceTriangles = new HashMap<EntityType<? extends IEntityRayTraceable>, Map<RayTracePart, TriangleRayTraceList>>();
    private final Map<EntityType<? extends IEntityRayTraceable>, Pair<Float, Float>> entityCrateScalesAndOffsets = new HashMap<EntityType<? extends IEntityRayTraceable>, Pair<Float, Float>>();
    private final Pair<Float, Float> SCALE_AND_OFFSET_DEFAULT = new ImmutablePair((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0f));
    private RayTraceResultRotated continuousInteraction;
    private Hand continuousInteractionHand;
    private int continuousInteractionTickCounter;

    private EntityRayTracer() {
    }

    public static EntityRayTracer instance() {
        if (instance == null) {
            instance = new EntityRayTracer();
        }
        return instance;
    }

    public void clearDataForReregistration() {
        this.entityRayTraceTrianglesStatic.clear();
        this.entityRayTraceTriangles.clear();
        this.entityCrateScalesAndOffsets.clear();
    }

    @Nullable
    public RayTraceResultRotated getContinuousInteraction() {
        return this.continuousInteraction;
    }

    @Nullable
    public Hand getContinuousInteractionHand() {
        return this.continuousInteractionHand;
    }

    public int getContinuousInteractionTickCounter() {
        return this.continuousInteractionTickCounter;
    }

    public <T extends VehicleEntity> void registerTransforms(EntityType<T> type, IRayTraceTransforms transforms) {
        this.entityRayTraceTransforms.putIfAbsent(type, transforms);
    }

    private static void createBodyTransforms(List<MatrixTransformation> transforms, EntityType<? extends VehicleEntity> entityType) {
        VehicleProperties properties = VehicleProperties.getProperties(entityType);
        PartPosition bodyPosition = properties.getBodyPosition();
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)bodyPosition.getRotX()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)bodyPosition.getRotY()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Z, (float)bodyPosition.getRotZ()));
        transforms.add(MatrixTransformation.createTranslation((float)bodyPosition.getX(), (float)bodyPosition.getY(), (float)bodyPosition.getZ()));
        transforms.add(MatrixTransformation.createScale((float)bodyPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, properties.getAxleOffset() * 0.0625f, 0.0f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, properties.getWheelOffset() * 0.0625f, 0.0f));
    }

    public static void createPartTransforms(ISpecialModel model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, -0.5f, 0.0f));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)partPosition.getRotX()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)partPosition.getRotY()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Z, (float)partPosition.getRotZ()));
        EntityRayTracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(ISpecialModel model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, RayTraceFunction function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, -0.5f, 0.0f));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)partPosition.getRotX()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)partPosition.getRotY()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Z, (float)partPosition.getRotZ()));
        EntityRayTracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(Item part, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, RayTraceFunction function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, -0.5f, 0.0f));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_X, (float)partPosition.getRotX()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Y, (float)partPosition.getRotY()));
        transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Z, (float)partPosition.getRotZ()));
        EntityRayTracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(double x, double y, double z, Vector3f rotation, double scale, List<MatrixTransformation> transforms) {
        transforms.add(MatrixTransformation.createTranslation((float)x * 0.0625f, (float)y * 0.0625f, (float)z * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0f, -0.5f, 0.0f));
        transforms.add(MatrixTransformation.createScale((float)scale));
        transforms.add(MatrixTransformation.createTranslation(0.0f, 0.5f, 0.0f));
        if (rotation.func_195899_a() != 0.0f) {
            transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_X, rotation.func_195899_a()));
        }
        if (rotation.func_195900_b() != 0.0f) {
            transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Y, rotation.func_195900_b()));
        }
        if (rotation.func_195902_c() != 0.0f) {
            transforms.add(MatrixTransformation.createRotation(Axis.POSITIVE_Z, rotation.func_195900_b()));
        }
    }

    public static void createFuelPartTransforms(EntityType<? extends VehicleEntity> entityType, ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition fuelPortPosition = VehicleProperties.getProperties(entityType).getFuelPortPosition();
        EntityRayTracer.createPartTransforms(model, fuelPortPosition, parts, transformsGlobal, RayTraceFunction.FUNCTION_FUELING);
    }

    public static void createFuelPartTransforms(Item part, double xMeters, double yMeters, double zMeters, double xPixel, double yPixel, double zPixel, double rotation, double scale, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList partTransforms = Lists.newArrayList();
        partTransforms.add(MatrixTransformation.createTranslation((float)xMeters, (float)yMeters, (float)zMeters));
        EntityRayTracer.createPartTransforms(xPixel, yPixel, zPixel, new Vector3f(0.0f, (float)rotation, 0.0f), scale, partTransforms);
        transformsGlobal.addAll(partTransforms);
        EntityRayTracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, transformsGlobal, RayTraceFunction.FUNCTION_FUELING, new MatrixTransformation[0]);
    }

    public static void createKeyPortTransforms(EntityType<? extends VehicleEntity> entityType, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition keyPortPosition = VehicleProperties.getProperties(entityType).getKeyPortPosition();
        EntityRayTracer.createPartTransforms(SpecialModels.KEY_HOLE, keyPortPosition, parts, transformsGlobal);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable RayTraceFunction continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart(part, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRayTracer.createTransformListForPart(part, parts, transformsGlobal, null, transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRayTracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, transformsGlobal, transforms);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRayTracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRayTracer.createTransformListForPart(part, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable RayTraceFunction continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart(model, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRayTracer.createTransformListForPart(model, parts, transformsGlobal, null, transforms);
    }

    private <T extends VehicleEntity> void generateEntityTriangles(EntityType<T> entityType, Map<RayTracePart, List<MatrixTransformation>> transforms) {
        HashMap<RayTracePart, TriangleRayTraceList> partTriangles = new HashMap<RayTracePart, TriangleRayTraceList>();
        for (Map.Entry<RayTracePart, List<MatrixTransformation>> entryPart : transforms.entrySet()) {
            Matrix4f matrix = new Matrix4f();
            matrix.func_226591_a_();
            for (MatrixTransformation transform : entryPart.getValue()) {
                transform.transform(matrix);
            }
            EntityRayTracer.finalizePartStackMatrix(matrix);
            RayTracePart part = entryPart.getKey();
            partTriangles.put(part, new TriangleRayTraceList(EntityRayTracer.generateTriangles(EntityRayTracer.getModel(part), matrix)));
        }
        this.entityRayTraceTrianglesStatic.put(entityType, partTriangles);
        HashMap<RayTracePart, TriangleRayTraceList> partTrianglesCopy = new HashMap<RayTracePart, TriangleRayTraceList>(partTriangles);
        Map<RayTracePart, TriangleRayTraceList> partTrianglesAll = this.entityRayTraceTriangles.get(entityType);
        if (partTrianglesAll != null) {
            partTrianglesCopy.putAll(partTrianglesAll);
        }
        this.entityRayTraceTriangles.put(entityType, partTrianglesCopy);
    }

    public Pair<Float, Float> getCrateScaleAndOffset(EntityType<? extends VehicleEntity> entityType) {
        Pair<Float, Float> scaleAndOffset = this.entityCrateScalesAndOffsets.get(entityType);
        return scaleAndOffset == null ? this.SCALE_AND_OFFSET_DEFAULT : scaleAndOffset;
    }

    private static IBakedModel getModel(RayTracePart part) {
        if (part.model != null) {
            return part.model.getModel();
        }
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(part.partStack, null, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    private static List<TriangleRayTrace> generateTriangles(IBakedModel model, @Nullable Matrix4f matrix) {
        ArrayList triangles = Lists.newArrayList();
        try {
            Random random = new Random();
            random.setSeed(42L);
            EntityRayTracer.generateTriangles(model.func_200117_a(null, null, random), matrix, triangles);
            for (Direction facing : Direction.values()) {
                random.setSeed(42L);
                EntityRayTracer.generateTriangles(model.func_200117_a(null, facing, random), matrix, triangles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return triangles;
    }

    private static void generateTriangles(List<BakedQuad> list, @Nullable Matrix4f matrix, List<TriangleRayTrace> triangles) {
        for (BakedQuad quad : list) {
            int size = DefaultVertexFormats.field_176600_a.func_181719_f();
            int[] data = quad.func_178209_a();
            float[] triangle1 = new float[9];
            float[] triangle2 = new float[9];
            triangle1[0] = Float.intBitsToFloat(data[0]);
            triangle1[1] = Float.intBitsToFloat(data[1]);
            triangle1[2] = Float.intBitsToFloat(data[2]);
            triangle1[3] = triangle2[6] = Float.intBitsToFloat(data[size]);
            triangle1[4] = triangle2[7] = Float.intBitsToFloat(data[size + 1]);
            triangle1[5] = triangle2[8] = Float.intBitsToFloat(data[size + 2]);
            triangle2[0] = Float.intBitsToFloat(data[size *= 2]);
            triangle2[1] = Float.intBitsToFloat(data[size + 1]);
            triangle2[2] = Float.intBitsToFloat(data[size + 2]);
            size = (int)((double)size * 1.5);
            triangle1[6] = triangle2[3] = Float.intBitsToFloat(data[size]);
            triangle1[7] = triangle2[4] = Float.intBitsToFloat(data[size + 1]);
            triangle1[8] = triangle2[5] = Float.intBitsToFloat(data[size + 2]);
            EntityRayTracer.transformTriangleAndAdd(triangle1, matrix, triangles);
            EntityRayTracer.transformTriangleAndAdd(triangle2, matrix, triangles);
        }
    }

    private static void transformTriangleAndAdd(float[] triangle, @Nullable Matrix4f matrix, List<TriangleRayTrace> triangles) {
        triangles.add(new TriangleRayTrace(matrix != null ? EntityRayTracer.getTransformedTriangle(triangle, matrix) : triangle));
    }

    private static float[] getTransformedTriangle(float[] triangle, Matrix4f matrix) {
        float[] triangleNew = new float[9];
        for (int i = 0; i < 9; i += 3) {
            Vector4f vec = new Vector4f(triangle[i], triangle[i + 1], triangle[i + 2], 1.0f);
            vec.func_229372_a_(matrix);
            triangleNew[i] = vec.func_195910_a();
            triangleNew[i + 1] = vec.func_195913_b();
            triangleNew[i + 2] = vec.func_195914_c();
        }
        return triangleNew;
    }

    public static void finalizePartStackMatrix(Matrix4f matrix) {
        MatrixTransformation.createTranslation(-0.5f, -0.5f, -0.5f).transform(matrix);
    }

    public static void interactWithEntity(IEntityRayTraceable entity, EntityRayTraceResult result) {
        Minecraft.func_71410_x().field_71442_b.func_187097_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (Entity)entity, Hand.MAIN_HAND);
        Minecraft.func_71410_x().field_71442_b.func_187102_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (Entity)entity, result, Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public void rayTraceEntitiesContinuously(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.continuousInteraction == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        RayTraceResultRotated result = this.rayTraceEntities(this.continuousInteraction.isRightClick());
        if (result == null || result.func_216348_a() != this.continuousInteraction.func_216348_a() || result.getPartHit() != this.continuousInteraction.getPartHit()) {
            this.continuousInteraction = null;
            this.continuousInteractionTickCounter = 0;
            return;
        }
        this.continuousInteractionHand = result.performContinuousInteraction();
        if (this.continuousInteractionHand == null) {
            this.continuousInteraction = null;
            this.continuousInteractionTickCounter = 0;
        } else {
            ++this.continuousInteractionTickCounter;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (((Boolean)Config.CLIENT.reloadRayTracerEachTick.get()).booleanValue()) {
            this.entityRayTraceTransforms.keySet().forEach(type -> this.initializeTransforms((EntityType)type, true));
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.RawMouseEvent event) {
        boolean leftClick;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_213279_p != null || mc.field_71462_r != null) {
            return;
        }
        boolean rightClick = event.getButton() == 1;
        boolean bl = leftClick = event.getButton() == 0;
        if (!((rightClick || ((Boolean)Config.CLIENT.enabledLeftClick.get()).booleanValue() && leftClick) && event.getAction() != 0)) {
            return;
        }
        if (this.performRayTrace(rightClick)) {
            event.setCanceled(true);
        }
    }

    private boolean performRayTrace(boolean rightClick) {
        RayTraceResultRotated result = this.rayTraceEntities(rightClick);
        if (result != null) {
            this.continuousInteractionHand = result.performContinuousInteraction();
            if (this.continuousInteractionHand != null) {
                this.continuousInteraction = result;
                this.continuousInteractionTickCounter = 1;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private <T extends VehicleEntity> RayTraceResultRotated rayTraceEntities(boolean rightClick) {
        double eyeDistance;
        float reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vector3d eyeVec = Minecraft.func_71410_x().field_71439_g.func_174824_e(1.0f);
        Vector3d forwardVec = eyeVec.func_178787_e(Minecraft.func_71410_x().field_71439_g.func_70676_i(1.0f).func_186678_a((double)reach));
        AxisAlignedBB box = new AxisAlignedBB(eyeVec, eyeVec).func_186662_g((double)reach);
        RayTraceResultRotated closestRayTraceResult = null;
        double closestDistance = Double.MAX_VALUE;
        for (VehicleEntity entity : Minecraft.func_71410_x().field_71441_e.func_217357_a(VehicleEntity.class, box)) {
            EntityType type = entity.func_200600_R();
            if (this.entityRayTraceTransforms.containsKey(type)) {
                double distance;
                this.initializeTransforms(type, false);
                RayTraceResultRotated rayTraceResult = this.rayTraceEntityRotated(entity, eyeVec, forwardVec, reach, rightClick);
                if (rayTraceResult == null || !((distance = rayTraceResult.getDistanceToEyes()) < closestDistance)) continue;
                closestRayTraceResult = rayTraceResult;
                closestDistance = distance;
                continue;
            }
            VehicleMod.LOGGER.warn("The vehicle '" + type.getRegistryName() + "' does not have any registered ray trace transforms.");
        }
        if (closestRayTraceResult != null && (eyeDistance = closestRayTraceResult.getDistanceToEyes()) <= (double)reach) {
            boolean bypass = this.entityRayTraceTrianglesStatic.keySet().contains(closestRayTraceResult.func_216348_a().func_200600_R());
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            if (bypass && result != null && result.func_216346_c() != RayTraceResult.Type.MISS) {
                AxisAlignedBB boxMC = null;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    boxMC = closestRayTraceResult.func_216348_a().func_174813_aQ();
                } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
                    boxMC = closestRayTraceResult.func_216348_a().field_70170_p.func_180495_p(pos).func_196954_c((IBlockReader)closestRayTraceResult.func_216348_a().field_70170_p, pos).func_197752_a();
                }
                bypass = boxMC != null && boxMC.func_72318_a(eyeVec);
            }
            Vector3d hit = forwardVec;
            if (!bypass && result != null && result.func_216346_c() != RayTraceResult.Type.MISS) {
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() == closestRayTraceResult.func_216348_a()) {
                    bypass = true;
                } else {
                    hit = result.func_216347_e();
                }
            }
            if ((bypass || eyeDistance < hit.func_72438_d(eyeVec)) && ((IEntityRayTraceable)closestRayTraceResult.func_216348_a()).processHit(closestRayTraceResult, rightClick)) {
                return closestRayTraceResult;
            }
        }
        return null;
    }

    private <T extends VehicleEntity> void initializeTransforms(EntityType<T> type, boolean reload) {
        if (!this.entityRayTraceTrianglesStatic.containsKey(type) || reload) {
            ArrayList<MatrixTransformation> transforms = new ArrayList<MatrixTransformation>();
            EntityRayTracer.createBodyTransforms(transforms, type);
            HashMap parts = Maps.newHashMap();
            IRayTraceTransforms rayTraceTransforms = this.entityRayTraceTransforms.get(type);
            rayTraceTransforms.load(this, transforms, parts);
            this.generateEntityTriangles(type, parts);
            float min = 0.0f;
            float max = 0.0f;
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : this.entityRayTraceTriangles.get(type).entrySet()) {
                for (TriangleRayTrace triangle : entry.getValue().getTriangles()) {
                    float[] data = triangle.getData();
                    for (int i = 0; i < data.length; i += 3) {
                        float x = data[i];
                        float y = data[i + 1];
                        float z = data[i + 2];
                        if (x < min) {
                            min = x;
                        }
                        if (y < min) {
                            min = y;
                        }
                        if (z < min) {
                            min = z;
                        }
                        if (x > max) {
                            max = x;
                        }
                        if (y > max) {
                            max = y;
                        }
                        if (!(z > max)) continue;
                        max = z;
                    }
                }
            }
            float range = max - min;
            this.entityCrateScalesAndOffsets.put(type, (Pair<Float, Float>)new ImmutablePair((Object)Float.valueOf(1.0f / (range * 1.25f)), (Object)Float.valueOf(-(min + range * 0.5f))));
        }
    }

    @Nullable
    public RayTraceResultRotated rayTraceEntityRotated(VehicleEntity entity, Vector3d eyeVec, Vector3d forwardVec, double reach, boolean rightClick) {
        Vector3d pos = entity.func_213303_ch();
        double angle = Math.toRadians(-entity.field_70177_z);
        Vector3d eyeVecRotated = EntityRayTracer.rotateVecXZ(eyeVec, angle, pos);
        Vector3d forwardVecRotated = EntityRayTracer.rotateVecXZ(forwardVec, angle, pos);
        float[] eyes = new float[]{(float)eyeVecRotated.field_72450_a, (float)eyeVecRotated.field_72448_b, (float)eyeVecRotated.field_72449_c};
        Vector3d look = forwardVecRotated.func_178788_d(eyeVecRotated).func_72432_b().func_186678_a(reach);
        float[] direction = new float[]{(float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c};
        double distanceShortest = Double.MAX_VALUE;
        RayTraceResultTriangle lookBox = EntityRayTracer.rayTracePartTriangles(entity, pos, eyeVecRotated, null, distanceShortest, eyes, direction, entity.getApplicableInteractionBoxes(), false, entity.getStaticInteractionBoxMap());
        RayTraceResultTriangle lookPart = EntityRayTracer.rayTracePartTriangles(entity, pos, eyeVecRotated, null, distanceShortest = EntityRayTracer.updateShortestDistance(lookBox, distanceShortest), eyes, direction, entity.getNonApplicableParts(), true, this.entityRayTraceTrianglesStatic.get(entity.func_200600_R()));
        if (lookPart != null) {
            return new RayTraceResultRotated(entity, EntityRayTracer.rotateVecXZ(lookPart.getHit(), -angle, pos), lookPart.getDistance(), lookPart.getPart(), rightClick);
        }
        return lookBox == null ? null : new RayTraceResultRotated(entity, EntityRayTracer.rotateVecXZ(lookBox.getHit(), -angle, pos), lookBox.getDistance(), lookBox.getPart(), rightClick);
    }

    private static double updateShortestDistance(RayTraceResultTriangle lookObject, double distanceShortest) {
        if (lookObject != null) {
            distanceShortest = lookObject.getDistance();
        }
        return distanceShortest;
    }

    private static RayTraceResultTriangle rayTracePartTriangles(Entity entity, Vector3d pos, Vector3d eyeVecRotated, RayTraceResultTriangle lookPart, double distanceShortest, float[] eyes, float[] direction, @Nullable List<RayTracePart> partsApplicable, boolean invalidateParts, Map<RayTracePart, TriangleRayTraceList> parts) {
        if (parts != null) {
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : parts.entrySet()) {
                if (partsApplicable != null && invalidateParts == partsApplicable.contains(entry.getKey())) continue;
                RayTracePart part = entry.getKey();
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(part, entity)) {
                    double distance;
                    RayTraceResultTriangle lookObjectPutative = RayTraceResultTriangle.calculateIntercept(eyes, direction, pos, triangle.getData(), part);
                    if (lookObjectPutative == null || !((distance = lookObjectPutative.calculateAndSaveDistance(eyeVecRotated)) < distanceShortest)) continue;
                    lookPart = lookObjectPutative;
                    distanceShortest = distance;
                }
            }
        }
        return lookPart;
    }

    private static Vector3d rotateVecXZ(Vector3d vec, double angle, Vector3d rotationPoint) {
        double x = rotationPoint.field_72450_a + Math.cos(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) - Math.sin(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        double z = rotationPoint.field_72449_c + Math.sin(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) + Math.cos(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        return new Vector3d(x, vec.field_72448_b, z);
    }

    public <T extends VehicleEntity> void renderRayTraceElements(T entity, MatrixStack matrixStack, float yaw) {
        if (((Boolean)Config.CLIENT.renderOutlines.get()).booleanValue()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yaw));
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
            RenderSystem.lineWidth((float)Math.max(2.0f, (float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / 1920.0f * 2.0f));
            RenderSystem.disableTexture();
            RenderSystem.disableLighting();
            RenderSystem.enableDepthTest();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            this.renderRayTraceTriangles(entity, tessellator, buffer);
            entity.drawInteractionBoxes(tessellator, buffer);
            RenderSystem.enableLighting();
            RenderSystem.enableTexture();
            RenderSystem.popMatrix();
            matrixStack.func_227865_b_();
        }
    }

    private <T extends VehicleEntity> void renderRayTraceTriangles(T entity, Tessellator tessellator, BufferBuilder buffer) {
        EntityType type = entity.func_200600_R();
        this.initializeTransforms(type, false);
        Map<RayTracePart, TriangleRayTraceList> map = this.entityRayTraceTriangles.get(type);
        if (map != null) {
            List partsNonApplicable = entity.getNonApplicableParts();
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : map.entrySet()) {
                if (partsNonApplicable != null && partsNonApplicable.contains(entry.getKey())) continue;
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(entry.getKey(), entity)) {
                    triangle.draw(tessellator, buffer, 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box, @Nullable BiFunction<RayTracePart, Entity, Matrix4f> matrixFactory) {
        ArrayList triangles = Lists.newArrayList();
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c);
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f);
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72334_f);
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c);
        EntityRayTracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        return new TriangleRayTraceList(triangles, matrixFactory);
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box) {
        return EntityRayTracer.boxToTriangles(box, null);
    }

    private static void getTrianglesFromQuadAndAdd(List<TriangleRayTrace> triangles, double ... data) {
        int size = 3;
        float[] triangle1 = new float[9];
        float[] triangle2 = new float[9];
        triangle1[0] = (float)data[0];
        triangle1[1] = (float)data[1];
        triangle1[2] = (float)data[2];
        triangle1[3] = triangle2[6] = (float)data[size];
        triangle1[4] = triangle2[7] = (float)data[size + 1];
        triangle1[5] = triangle2[8] = (float)data[size + 2];
        triangle2[0] = (float)data[size *= 2];
        triangle2[1] = (float)data[size + 1];
        triangle2[2] = (float)data[size + 2];
        size = (int)((double)size * 1.5);
        triangle1[6] = triangle2[3] = (float)data[size];
        triangle1[7] = triangle2[4] = (float)data[size + 1];
        triangle1[8] = triangle2[5] = (float)data[size + 2];
        EntityRayTracer.transformTriangleAndAdd(triangle1, null, triangles);
        EntityRayTracer.transformTriangleAndAdd(triangle2, null, triangles);
    }

    public static interface IRayTraceTransforms {
        public void load(EntityRayTracer var1, List<MatrixTransformation> var2, HashMap<RayTracePart, List<MatrixTransformation>> var3);
    }

    public static interface IEntityRayTraceable {
        @OnlyIn(value=Dist.CLIENT)
        default public boolean processHit(RayTraceResultRotated result, boolean rightClick) {
            boolean isContinuous;
            if (result.getPartHit().getModel() == SpecialModels.KEY_HOLE) {
                PacketHandler.instance.sendToServer((Object)new MessageInteractKey((Entity)this));
                return true;
            }
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = isContinuous = result.partHit.getContinuousInteraction() != null;
            if (isContinuous || mc.field_71476_x == null || mc.field_71476_x.func_216346_c() != RayTraceResult.Type.ENTITY || ((EntityRayTraceResult)mc.field_71476_x).func_216348_a() != this) {
                boolean notRiding;
                ClientPlayerEntity player = mc.field_71439_g;
                boolean bl2 = notRiding = player.func_184187_bx() != this;
                if (!rightClick && notRiding) {
                    mc.field_71442_b.func_78764_a((PlayerEntity)player, (Entity)this);
                    return true;
                }
                if (result.getPartHit().model != null || result.getPartHit().partStack != null) {
                    if (notRiding) {
                        if (player.func_213453_ef() && !player.func_175149_v()) {
                            PacketHandler.instance.sendToServer((Object)new MessagePickupVehicle((Entity)this));
                            return true;
                        }
                        if (!isContinuous) {
                            EntityRayTracer.interactWithEntity(this, result);
                        }
                    }
                    return notRiding;
                }
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getStaticInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @OnlyIn(value=Dist.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getDynamicInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        default public List<RayTracePart> getApplicableInteractionBoxes() {
            return null;
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        default public List<RayTracePart> getNonApplicableParts() {
            return null;
        }

        @OnlyIn(value=Dist.CLIENT)
        default public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        }
    }

    public static class RayTraceResultRotated
    extends EntityRayTraceResult {
        private final RayTracePart partHit;
        private final double distanceToEyes;
        private final boolean rightClick;

        private RayTraceResultRotated(Entity entityHit, Vector3d hitVec, double distanceToEyes, RayTracePart partHit, boolean rightClick) {
            super(entityHit, hitVec);
            this.distanceToEyes = distanceToEyes;
            this.partHit = partHit;
            this.rightClick = rightClick;
        }

        public RayTracePart getPartHit() {
            return this.partHit;
        }

        public double getDistanceToEyes() {
            return this.distanceToEyes;
        }

        public boolean isRightClick() {
            return this.rightClick;
        }

        public Hand performContinuousInteraction() {
            return this.partHit.getContinuousInteraction() == null ? null : this.partHit.getContinuousInteraction().apply(EntityRayTracer.instance(), this, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        }

        public <R> boolean equalsContinuousInteraction(RayTraceFunction function) {
            return function.equals(this.partHit.getContinuousInteraction());
        }
    }

    public static class RayTracePart {
        private final ItemStack partStack;
        private final AxisAlignedBB partBox;
        private final ISpecialModel model;
        private final RayTraceFunction continuousInteraction;

        public RayTracePart(ItemStack partStack, @Nullable RayTraceFunction continuousInteraction) {
            this(partStack, null, null, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox, @Nullable RayTraceFunction continuousInteraction) {
            this(ItemStack.field_190927_a, partBox, null, continuousInteraction);
        }

        public RayTracePart(ISpecialModel model, @Nullable RayTraceFunction continuousInteraction) {
            this(ItemStack.field_190927_a, null, model, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox) {
            this(ItemStack.field_190927_a, partBox, null, null);
        }

        private RayTracePart(ItemStack partStack, @Nullable AxisAlignedBB partBox, @Nullable ISpecialModel model, @Nullable RayTraceFunction continuousInteraction) {
            this.partStack = partStack;
            this.partBox = partBox;
            this.model = model;
            this.continuousInteraction = continuousInteraction;
        }

        public ItemStack getStack() {
            return this.partStack;
        }

        @Nullable
        public AxisAlignedBB getBox() {
            return this.partBox;
        }

        @Nullable
        public ISpecialModel getModel() {
            return this.model;
        }

        public RayTraceFunction getContinuousInteraction() {
            return this.continuousInteraction;
        }
    }

    private static class RayTraceResultTriangle {
        private static final float EPSILON = 1.0E-6f;
        private final float x;
        private final float y;
        private final float z;
        private final RayTracePart part;
        private double distance;

        public RayTraceResultTriangle(RayTracePart part, float x, float y, float z) {
            this.part = part;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3d getHit() {
            return new Vector3d((double)this.x, (double)this.y, (double)this.z);
        }

        public RayTracePart getPart() {
            return this.part;
        }

        public double calculateAndSaveDistance(Vector3d eyeVec) {
            this.distance = eyeVec.func_72438_d(this.getHit());
            return this.distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public static RayTraceResultTriangle calculateIntercept(float[] eyes, float[] direction, Vector3d posEntity, float[] data, RayTracePart part) {
            float[] vec0 = new float[]{data[0] + (float)posEntity.field_72450_a, data[1] + (float)posEntity.field_72448_b, data[2] + (float)posEntity.field_72449_c};
            float[] vec1 = new float[]{data[3] + (float)posEntity.field_72450_a, data[4] + (float)posEntity.field_72448_b, data[5] + (float)posEntity.field_72449_c};
            float[] vec2 = new float[]{data[6] + (float)posEntity.field_72450_a, data[7] + (float)posEntity.field_72448_b, data[8] + (float)posEntity.field_72449_c};
            float[] edge1 = new float[3];
            float[] edge2 = new float[3];
            float[] tvec = new float[3];
            float[] pvec = new float[3];
            float[] qvec = new float[3];
            RayTraceResultTriangle.subtract(edge1, vec1, vec0);
            RayTraceResultTriangle.subtract(edge2, vec2, vec0);
            RayTraceResultTriangle.crossProduct(pvec, direction, edge2);
            float det = RayTraceResultTriangle.dotProduct(edge1, pvec);
            if (det <= -1.0E-6f || det >= 1.0E-6f) {
                float inv_det = 1.0f / det;
                RayTraceResultTriangle.subtract(tvec, eyes, vec0);
                float u = RayTraceResultTriangle.dotProduct(tvec, pvec) * inv_det;
                if (u >= 0.0f && u <= 1.0f) {
                    RayTraceResultTriangle.crossProduct(qvec, tvec, edge1);
                    float v = RayTraceResultTriangle.dotProduct(direction, qvec) * inv_det;
                    if (v >= 0.0f && u + v <= 1.0f && inv_det * RayTraceResultTriangle.dotProduct(edge2, qvec) > 1.0E-6f) {
                        return new RayTraceResultTriangle(part, edge1[0] * u + edge2[0] * v + vec0[0], edge1[1] * u + edge2[1] * v + vec0[1], edge1[2] * u + edge2[2] * v + vec0[2]);
                    }
                }
            }
            return null;
        }

        private static void crossProduct(float[] result, float[] v1, float[] v2) {
            result[0] = v1[1] * v2[2] - v1[2] * v2[1];
            result[1] = v1[2] * v2[0] - v1[0] * v2[2];
            result[2] = v1[0] * v2[1] - v1[1] * v2[0];
        }

        private static float dotProduct(float[] v1, float[] v2) {
            return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        }

        private static void subtract(float[] result, float[] v1, float[] v2) {
            result[0] = v1[0] - v2[0];
            result[1] = v1[1] - v2[1];
            result[2] = v1[2] - v2[2];
        }
    }

    public static class TriangleRayTraceList {
        private final List<TriangleRayTrace> triangles;
        private final BiFunction<RayTracePart, Entity, Matrix4f> matrixFactory;

        public TriangleRayTraceList(List<TriangleRayTrace> triangles) {
            this(triangles, null);
        }

        public TriangleRayTraceList(List<TriangleRayTrace> triangles, @Nullable BiFunction<RayTracePart, Entity, Matrix4f> matrixFactory) {
            this.triangles = triangles;
            this.matrixFactory = matrixFactory;
        }

        public List<TriangleRayTrace> getTriangles(RayTracePart part, Entity entity) {
            if (this.matrixFactory != null) {
                ArrayList triangles = Lists.newArrayList();
                Matrix4f matrix = this.matrixFactory.apply(part, entity);
                for (TriangleRayTrace triangle : this.triangles) {
                    triangles.add(new TriangleRayTrace(EntityRayTracer.getTransformedTriangle(triangle.getData(), matrix)));
                }
                return triangles;
            }
            return this.triangles;
        }

        public List<TriangleRayTrace> getTriangles() {
            return this.triangles;
        }
    }

    public static class TriangleRayTrace {
        private final float[] data;

        public TriangleRayTrace(float[] data) {
            this.data = data;
        }

        public float[] getData() {
            return this.data;
        }

        public void draw(Tessellator tessellator, BufferBuilder buffer, float red, float green, float blue, float alpha) {
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_((double)this.data[6], (double)this.data[7], (double)this.data[8]).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)this.data[0], (double)this.data[1], (double)this.data[2]).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_225582_a_((double)this.data[3], (double)this.data[4], (double)this.data[5]).func_227885_a_(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class MatrixTransformation {
        private final MatrixTransformationType type;
        private float x;
        private float y;
        private float z;
        private float angle;

        public MatrixTransformation(MatrixTransformationType type, float x, float y, float z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public MatrixTransformation(MatrixTransformationType type, float x, float y, float z, float angle) {
            this(type, x, y, z);
            this.angle = angle;
        }

        public static MatrixTransformation createTranslation(float x, float y, float z) {
            return new MatrixTransformation(MatrixTransformationType.TRANSLATION, x, y, z);
        }

        public static MatrixTransformation createRotation(Vector3f axis, float angle) {
            return new MatrixTransformation(MatrixTransformationType.ROTATION, axis.func_195899_a(), axis.func_195900_b(), axis.func_195902_c(), angle);
        }

        public static MatrixTransformation createScale(float x, float y, float z) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, x, y, z);
        }

        public static MatrixTransformation createScale(float xyz) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, xyz, xyz, xyz);
        }

        public void transform(Matrix4f matrix) {
            MatrixStack matrixStack = new MatrixStack();
            switch (this.type) {
                case ROTATION: {
                    matrixStack.func_227863_a_(new Vector3f(this.x, this.y, this.z).func_229187_a_(this.angle));
                    break;
                }
                case TRANSLATION: {
                    matrixStack.func_227861_a_((double)this.x, (double)this.y, (double)this.z);
                    break;
                }
                case SCALE: {
                    matrixStack.func_227862_a_(this.x, this.y, this.z);
                }
            }
            matrix.func_226595_a_(matrixStack.func_227866_c_().func_227870_a_());
        }

        private static enum MatrixTransformationType {
            TRANSLATION,
            ROTATION,
            SCALE;

        }
    }
}

