/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.proxy;

import com.mrcrayfish.vehicle.entity.HelicopterEntity;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fluids.FluidStack;

public interface Proxy {
    default public void setupClient() {
    }

    default public void playVehicleSound(PlayerEntity player, PoweredVehicleEntity vehicle) {
    }

    default public void syncStorageInventory(int entityId, CompoundNBT compound) {
    }

    default public void syncHeldVehicle(int entityId, CompoundNBT compound) {
    }

    default public void syncEntityFluid(int entityId, FluidStack stack) {
    }

    default public void playSound(SoundEvent sound, BlockPos pos, float volume, float pitch) {
    }

    default public void playSound(SoundEvent sound, float volume, float pitch) {
    }

    default public PoweredVehicleEntity.AccelerationDirection getAccelerationDirection(LivingEntity entity) {
        return PoweredVehicleEntity.AccelerationDirection.NONE;
    }

    default public PoweredVehicleEntity.TurnDirection getTurnDirection(LivingEntity entity) {
        return PoweredVehicleEntity.TurnDirection.FORWARD;
    }

    default public float getTargetTurnAngle(PoweredVehicleEntity vehicle, boolean drifting) {
        return 0.0f;
    }

    default public boolean isDrifting() {
        return false;
    }

    default public boolean isHonking() {
        return false;
    }

    default public PlaneEntity.FlapDirection getFlapDirection() {
        return PlaneEntity.FlapDirection.NONE;
    }

    default public HelicopterEntity.AltitudeChange getAltitudeChange() {
        return HelicopterEntity.AltitudeChange.NONE;
    }

    default public float getTravelDirection(HelicopterEntity vehicle) {
        return 0.0f;
    }

    default public float getTravelSpeed(HelicopterEntity helicopter) {
        return 0.0f;
    }

    default public float getPower(PoweredVehicleEntity vehicle) {
        return 1.0f;
    }

    default public boolean canApplyVehicleYaw(Entity passenger) {
        return false;
    }

    default public void syncPlayerSeat(int entityId, int seatIndex, UUID uuid) {
    }

    default public void spawnWheelParticle(BlockPos pos, BlockState state, double x, double y, double z, Vector3d motion) {
    }
}

